<?php

/**
 * TeacherClass
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    hotel
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class TeacherClass extends BaseTeacherClass {

  const ACTIVE = 1;
  const ARCHIVE = 2;

  public function getUsersCount() {
    $id = $this->getId();
    $count = $this->getClassHasUsers()->count();
            
//            Doctrine_Core::getTable('ClassUser')->createQuery('cu')
//            ->where('cu.class_id = ?', $id)
//            ->count();
    return $count;
  }

  public function isActive() {
    return $this->getStatus() == self::ACTIVE;
  }

  public function isArchive() {
    return $this->getStatus() == self::ARCHIVE;
  }

  public function getStatusText() {
    if ($this->isActive())
      $status = __('Active');
    if ($this->isArchive())
      $status = __('Archive');

    return $status;
  }

  /**
   * Zwraca dostępne statusy do formularzy. 
   * 
   * @return array
   */
  public static function returnAvailableStatus() {

    return array(
        self::ARCHIVE  => __('Archiwum'),
        self::ACTIVE => __('Aktywny')
    );
  }
  
  public function getTeacherName() {
    $teacherName = $this->getTeacher()->getFirstAndLastName();
    
    return $teacherName;
  }

}
