<?php

/**
 * TeacherClassTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class TeacherClassTable extends artDoctrineTable {

  /**
   * Returns an instance of this class.
   *
   * @return object TeacherClassTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('TeacherClass');
  }

  /**
   * Pobiera listę klas dla danego nauczyciela. GENERATOR
   * 
   * @return ;
   */
  public static function getClassesForTeacher($teacherId = false) {
    if ($teacherId) {
      $teacherId = sfContext::getInstance()->getUser()->getId();
    }

    return Doctrine_Core::getTable('TeacherClass')->createQuery('tc')
                    ->leftJoin('tc.class_has_users tcchu')
                    ->where('tc.teacher_id = ?', $teacherId);
  }

  /**
   * Pobiera listę wszystkich klas dla admina. GENERATOR
   * 
   * @return ;
   */
  public static function getClassesForAdmin() {
    return Doctrine_Core::getTable('TeacherClass')->createQuery('tc')
                    ->leftJoin('tc.class_has_users tcchu')
                    ->leftJoin('tc.Teacher t');
  }

  /**
   * Ustawia filtr na statusie klasy.
   * 
   * @return ;
   */
  public static function setStatusFilter($query, $value) {
    $rootAlias = $query->getRootAlias();

    $query->andWhereIn($rootAlias . '.status', $value);

    return $query;
  }

}