<?php

/**
 * TeamTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class TeamTable extends artDoctrineTable {

  public function getTeacherTeams() {

    $gameId = sfContext::getInstance()->getUser()->getAttribute('game_id', false);

    return Doctrine_Query::create()
                    ->select('id, name')
                    ->from('Team')
                    ->andWhere('game_id = ? ', $gameId)
                    ->groupBy('name')
                    ->execute();
  }
  
  public function getPanelTeamsForGame() {
    $gameId = sfContext::getInstance()->getUser()->getAttribute('panel_game_id', false);

    return $this->createQuery('t')
            ->leftJoin('t.user_has_teams ut')
            ->leftJoin('ut.User u')
            ->andWhere('t.game_id = ? ', $gameId);
  }

  /**
   * Returns an instance of this class.
   *
   * @return object TeamTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('Team');
  }

  public function getDataForGameController($teamId) {
    $object = $this->getInstance()->createQuery('t')
            ->leftJoin('t.rounds r')
            ->leftJoin('t.Game g')
            ->leftJoin('t.user_has_teams uht')
            ->where('t.id = ?', $teamId)
            ->andWhere('r.status = ? OR r.round_number = ?', array(Round::ACTIVE, HotelGameController::LAST_ROUND))
            ->fetchOne();

    if ($object) {
      if ($object->getRounds()->getFirst()->getRoundNumber() > 0) {
        
        $lastRound = Doctrine::getTable('Round')
                ->createQuery('r')
                ->where('r.team_id = ?', $teamId)
                ->andWhere('r.round_number = ?', $object->getRounds()->getFirst()->getRoundNumber() - 1)
                ->fetchOne();
        
        if ($lastRound) {
          $object->getRounds()->add($lastRound);
        }
      }
    }

    return $object;
  }

  /**
   * Pobiera listę gier dla danej klasy. GENERATOR
   */
  public function getTeamsForGame() {
    $gameId = sfContext::getInstance()->getUser()->getAttribute('game_id', false);

    return Doctrine_Core::getTable('Team')->createQuery('t')
                    ->leftJoin('t.user_has_teams tt')
                    ->where('t.game_id = ?', $gameId);
  }
  
    /**
   * Pobiera listę gier dla danej klasy. GENERATOR
   */
  public function getTeamsByGameId($gameId) {
    return Doctrine_Core::getTable('Team')->createQuery('t')
                    ->leftJoin('t.user_has_teams tt')
                    ->where('t.game_id = ?', $gameId)
                    ->execute();
  }

  public function getActiveTeams($userId) {
    return $this->createQuery('t')
                    ->leftJoin('t.UserTeam ut')
                    ->leftJoin('t.Game g')
                    ->where('ut.user_id = ?', $userId)
                    ->andWhere('g.status = ?', Game::ACTIVE)
                    ->execute();
  }
  
  public function getUserTeams($userId) {
    return $this->createQuery('t')
                    ->leftJoin('t.UserTeam ut')
                    ->leftJoin('t.Game g')
                    ->where('ut.user_id = ?', $userId)
                    ->execute();
  }

}
