<?php

/**
 * BaseArticle
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $creator_id
 * @property integer $editor_id
 * @property integer $layout_id
 * @property string $unique_name
 * @property integer $is_displayed
 * @property timestamp $start_at
 * @property timestamp $expire_at
 * @property clob $flag
 * @property string $title_image
 * @property string $title_image_label
 * @property string $big_image
 * @property integer $views
 * @property float $vote_sum
 * @property integer $vote_count
 * @property string $source
 * @property string $title
 * @property clob $description
 * @property string $short_description
 * @property string $meta_title
 * @property string $meta_description
 * @property string $meta_keywords
 * @property sfGuardUser $sfGuardUser
 * @property sfGuardUser $sfGuardUserEditor
 * @property Layout $Layout
 * @property Doctrine_Collection $Categories
 * @property Doctrine_Collection $Tags
 * @property Doctrine_Collection $Permissions
 * @property Doctrine_Collection $Groups
 * @property Doctrine_Collection $articleCategories
 * @property Doctrine_Collection $articleTags
 * @property Doctrine_Collection $articlePermissions
 * @property Doctrine_Collection $articleGroups
 * @property Doctrine_Collection $articlePhotoes
 * @property Doctrine_Collection $articleComments
 * @property Doctrine_Collection $articleFiles
 * @property Doctrine_Collection $ArticleBlogCategories
 * @property Doctrine_Collection $articleArticleBlogCategories
 * 
 * @method integer             getId()                           Returns the current record's "id" value
 * @method integer             getCreatorId()                    Returns the current record's "creator_id" value
 * @method integer             getEditorId()                     Returns the current record's "editor_id" value
 * @method integer             getLayoutId()                     Returns the current record's "layout_id" value
 * @method string              getUniqueName()                   Returns the current record's "unique_name" value
 * @method integer             getIsDisplayed()                  Returns the current record's "is_displayed" value
 * @method timestamp           getStartAt()                      Returns the current record's "start_at" value
 * @method timestamp           getExpireAt()                     Returns the current record's "expire_at" value
 * @method clob                getFlag()                         Returns the current record's "flag" value
 * @method string              getTitleImage()                   Returns the current record's "title_image" value
 * @method string              getTitleImageLabel()              Returns the current record's "title_image_label" value
 * @method string              getBigImage()                     Returns the current record's "big_image" value
 * @method integer             getViews()                        Returns the current record's "views" value
 * @method float               getVoteSum()                      Returns the current record's "vote_sum" value
 * @method integer             getVoteCount()                    Returns the current record's "vote_count" value
 * @method string              getSource()                       Returns the current record's "source" value
 * @method string              getTitle()                        Returns the current record's "title" value
 * @method clob                getDescription()                  Returns the current record's "description" value
 * @method string              getShortDescription()             Returns the current record's "short_description" value
 * @method string              getMetaTitle()                    Returns the current record's "meta_title" value
 * @method string              getMetaDescription()              Returns the current record's "meta_description" value
 * @method string              getMetaKeywords()                 Returns the current record's "meta_keywords" value
 * @method sfGuardUser         getSfGuardUser()                  Returns the current record's "sfGuardUser" value
 * @method sfGuardUser         getSfGuardUserEditor()            Returns the current record's "sfGuardUserEditor" value
 * @method Layout              getLayout()                       Returns the current record's "Layout" value
 * @method Doctrine_Collection getCategories()                   Returns the current record's "Categories" collection
 * @method Doctrine_Collection getTags()                         Returns the current record's "Tags" collection
 * @method Doctrine_Collection getPermissions()                  Returns the current record's "Permissions" collection
 * @method Doctrine_Collection getGroups()                       Returns the current record's "Groups" collection
 * @method Doctrine_Collection getArticleCategories()            Returns the current record's "articleCategories" collection
 * @method Doctrine_Collection getArticleTags()                  Returns the current record's "articleTags" collection
 * @method Doctrine_Collection getArticlePermissions()           Returns the current record's "articlePermissions" collection
 * @method Doctrine_Collection getArticleGroups()                Returns the current record's "articleGroups" collection
 * @method Doctrine_Collection getArticlePhotoes()               Returns the current record's "articlePhotoes" collection
 * @method Doctrine_Collection getArticleComments()              Returns the current record's "articleComments" collection
 * @method Doctrine_Collection getArticleFiles()                 Returns the current record's "articleFiles" collection
 * @method Doctrine_Collection getArticleBlogCategories()        Returns the current record's "ArticleBlogCategories" collection
 * @method Doctrine_Collection getArticleArticleBlogCategories() Returns the current record's "articleArticleBlogCategories" collection
 * @method Article             setId()                           Sets the current record's "id" value
 * @method Article             setCreatorId()                    Sets the current record's "creator_id" value
 * @method Article             setEditorId()                     Sets the current record's "editor_id" value
 * @method Article             setLayoutId()                     Sets the current record's "layout_id" value
 * @method Article             setUniqueName()                   Sets the current record's "unique_name" value
 * @method Article             setIsDisplayed()                  Sets the current record's "is_displayed" value
 * @method Article             setStartAt()                      Sets the current record's "start_at" value
 * @method Article             setExpireAt()                     Sets the current record's "expire_at" value
 * @method Article             setFlag()                         Sets the current record's "flag" value
 * @method Article             setTitleImage()                   Sets the current record's "title_image" value
 * @method Article             setTitleImageLabel()              Sets the current record's "title_image_label" value
 * @method Article             setBigImage()                     Sets the current record's "big_image" value
 * @method Article             setViews()                        Sets the current record's "views" value
 * @method Article             setVoteSum()                      Sets the current record's "vote_sum" value
 * @method Article             setVoteCount()                    Sets the current record's "vote_count" value
 * @method Article             setSource()                       Sets the current record's "source" value
 * @method Article             setTitle()                        Sets the current record's "title" value
 * @method Article             setDescription()                  Sets the current record's "description" value
 * @method Article             setShortDescription()             Sets the current record's "short_description" value
 * @method Article             setMetaTitle()                    Sets the current record's "meta_title" value
 * @method Article             setMetaDescription()              Sets the current record's "meta_description" value
 * @method Article             setMetaKeywords()                 Sets the current record's "meta_keywords" value
 * @method Article             setSfGuardUser()                  Sets the current record's "sfGuardUser" value
 * @method Article             setSfGuardUserEditor()            Sets the current record's "sfGuardUserEditor" value
 * @method Article             setLayout()                       Sets the current record's "Layout" value
 * @method Article             setCategories()                   Sets the current record's "Categories" collection
 * @method Article             setTags()                         Sets the current record's "Tags" collection
 * @method Article             setPermissions()                  Sets the current record's "Permissions" collection
 * @method Article             setGroups()                       Sets the current record's "Groups" collection
 * @method Article             setArticleCategories()            Sets the current record's "articleCategories" collection
 * @method Article             setArticleTags()                  Sets the current record's "articleTags" collection
 * @method Article             setArticlePermissions()           Sets the current record's "articlePermissions" collection
 * @method Article             setArticleGroups()                Sets the current record's "articleGroups" collection
 * @method Article             setArticlePhotoes()               Sets the current record's "articlePhotoes" collection
 * @method Article             setArticleComments()              Sets the current record's "articleComments" collection
 * @method Article             setArticleFiles()                 Sets the current record's "articleFiles" collection
 * @method Article             setArticleBlogCategories()        Sets the current record's "ArticleBlogCategories" collection
 * @method Article             setArticleArticleBlogCategories() Sets the current record's "articleArticleBlogCategories" collection
 * 
 * @package    hotel
 * @subpackage model

 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseArticle extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('creator_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('editor_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('layout_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('unique_name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('is_displayed', 'integer', 1, array(
             'type' => 'integer',
             'default' => 1,
             'length' => 1,
             ));
        $this->hasColumn('start_at', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
        $this->hasColumn('expire_at', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
        $this->hasColumn('flag', 'clob', 65535, array(
             'type' => 'clob',
             'length' => 65535,
             ));
        $this->hasColumn('title_image', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('title_image_label', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('big_image', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('views', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('vote_sum', 'float', null, array(
             'type' => 'float',
             ));
        $this->hasColumn('vote_count', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('source', 'string', 500, array(
             'type' => 'string',
             'length' => 500,
             ));
        $this->hasColumn('title', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 255,
             ));
        $this->hasColumn('description', 'clob', 65535, array(
             'type' => 'clob',
             'notnull' => true,
             'length' => 65535,
             ));
        $this->hasColumn('short_description', 'string', 1000, array(
             'type' => 'string',
             'length' => 1000,
             ));
        $this->hasColumn('meta_title', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('meta_description', 'string', 1000, array(
             'type' => 'string',
             'length' => 1000,
             ));
        $this->hasColumn('meta_keywords', 'string', 1000, array(
             'type' => 'string',
             'length' => 1000,
             ));


        $this->index('fk_article_sf_guard_user', array(
             'fields' => 
             array(
              0 => 'creator_id',
             ),
             ));
        $this->index('fk_article_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'editor_id',
             ),
             ));
        $this->index('fk_article_layout1', array(
             'fields' => 
             array(
              0 => 'layout_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser', array(
             'local' => 'creator_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('sfGuardUser as sfGuardUserEditor', array(
             'local' => 'editor_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('Layout', array(
             'local' => 'layout_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('Category as Categories', array(
             'refClass' => 'ArticleCategory',
             'local' => 'article_id',
             'foreign' => 'category_id'));

        $this->hasMany('Tag as Tags', array(
             'refClass' => 'ArticleTag',
             'local' => 'article_id',
             'foreign' => 'tag_id'));

        $this->hasMany('sfGuardPermission as Permissions', array(
             'refClass' => 'ArticlePermission',
             'local' => 'article_id',
             'foreign' => 'permission_id'));

        $this->hasMany('sfGuardGroup as Groups', array(
             'refClass' => 'ArticleGroup',
             'local' => 'article_id',
             'foreign' => 'group_id'));

        $this->hasMany('ArticleCategory as articleCategories', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticleTag as articleTags', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticlePermission as articlePermissions', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticleGroup as articleGroups', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticlePhoto as articlePhotoes', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticleComment as articleComments', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticleFile as articleFiles', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticleBlogCategory as ArticleBlogCategories', array(
             'refClass' => 'ArticleArticleBlogCategory',
             'local' => 'article_id',
             'foreign' => 'article_blog_category_id'));

        $this->hasMany('ArticleArticleBlogCategory as articleArticleBlogCategories', array(
             'local' => 'id',
             'foreign' => 'article_id'));

        $searchable0 = new Doctrine_Template_Searchable(array(
             'fields' => 
             array(
             ),
             'analyzer' => 'PolishSearchableAnalyzer',
             ));
        $timestampable0 = new Doctrine_Template_Timestampable();
        $i18n0 = new Doctrine_Template_I18n(array(
             'fields' => 
             array(
              0 => 'title',
              1 => 'description',
              2 => 'short_description',
              3 => 'meta_title',
              4 => 'meta_description',
              5 => 'meta_keywords',
             ),
             ));
        $sluggable1 = new Doctrine_Template_Sluggable(array(
             'fields' => 
             array(
              0 => 'title',
             ),
             'uniqueBy' => 
             array(
              0 => 'lang',
              1 => 'title',
             ),
             'canUpdate' => true,
             'builder' => 
             array(
              0 => 'Slug',
              1 => 'slugifySchemaArticle',
             ),
             ));
        $i18n0->addChild($sluggable1);
        $searchable1 = new Doctrine_Template_Searchable(array(
             'fields' => 
             array(
             ),
             'analyzer' => 'PolishSearchableAnalyzer',
             ));
        $i18n0->addChild($searchable1);
        $this->actAs($searchable0);
        $this->actAs($timestampable0);
        $this->actAs($i18n0);
    }
}