<?php


abstract class BaseArticleArticleBlogCategory extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article_article_blog_category');
        $this->hasColumn('article_blog_category_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('article_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));


        $this->index('fk_article_article_blog_category_article_blog_category', array(
             'fields' => 
             array(
              0 => 'article_blog_category_id',
             ),
             ));
        $this->index('fk_article_article_blog_category_article1', array(
             'fields' => 
             array(
              0 => 'article_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('ArticleBlogCategory', array(
             'local' => 'article_blog_category_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('Article', array(
             'local' => 'article_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}