<?php


abstract class BaseArticleBlogCategory extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article_blog_category');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 500, array(
             'type' => 'string',
             'length' => 500,
             ));

        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('Article as Articles', array(
             'refClass' => 'ArticleArticleBlogCategory',
             'local' => 'article_blog_category_id',
             'foreign' => 'article_id'));

        $this->hasMany('ArticleArticleBlogCategory as articleArticleBlogCategories', array(
             'local' => 'id',
             'foreign' => 'article_blog_category_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $i18n0 = new Doctrine_Template_I18n(array(
             'fields' => 
             array(
              0 => 'name',
             ),
             ));
        $this->actAs($timestampable0);
        $this->actAs($i18n0);
    }
}