<?php


abstract class BaseArticleComment extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article_comment');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('article_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('parent_article_comment_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('text', 'clob', 65535, array(
             'type' => 'clob',
             'notnull' => true,
             'length' => 65535,
             ));
        $this->hasColumn('display', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => 1,
             ));
        $this->hasColumn('nick', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('email', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('www', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('gg', 'string', 45, array(
             'type' => 'string',
             'length' => 45,
             ));
        $this->hasColumn('notify', 'boolean', null, array(
             'type' => 'boolean',
             'default' => 0,
             ));


        $this->index('fk_article_comment_article1', array(
             'fields' => 
             array(
              0 => 'article_id',
             ),
             ));
        $this->index('fk_article_comment_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->index('fk_article_comment_article_comment1', array(
             'fields' => 
             array(
              0 => 'parent_article_comment_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Article', array(
             'local' => 'article_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('sfGuardUser', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('ArticleComment', array(
             'local' => 'parent_article_comment_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('ArticleComment as articleComments', array(
             'local' => 'id',
             'foreign' => 'parent_article_comment_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}