<?php


abstract class BaseArticleGroup extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article_group');
        $this->hasColumn('article_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('group_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));


        $this->index('fk_article_group_article1', array(
             'fields' => 
             array(
              0 => 'article_id',
             ),
             ));
        $this->index('fk_article_group_sf_guard_group1', array(
             'fields' => 
             array(
              0 => 'group_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Article', array(
             'local' => 'article_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('sfGuardGroup', array(
             'local' => 'group_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));
    }
}