<?php


abstract class BaseArticleTag extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article_article_tag');
        $this->hasColumn('article_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('tag_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));


        $this->index('fk_article_tag_article1', array(
             'fields' => 
             array(
              0 => 'article_id',
             ),
             ));
        $this->index('fk_article_tag_tag1', array(
             'fields' => 
             array(
              0 => 'tag_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Article', array(
             'local' => 'article_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('Tag', array(
             'local' => 'tag_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));
    }
}