<?php


abstract class BaseCategory extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('article_category');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('title_image', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('unique_name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('name', 'string', 100, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 100,
             ));
        $this->hasColumn('description', 'string', 1024, array(
             'type' => 'string',
             'length' => 1024,
             ));
        $this->hasColumn('image_count', 'integer', 4, array(
             'type' => 'integer',
             'default' => 1,
             'length' => 4,
             ));
        $this->hasColumn('layout_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('is_displayed', 'integer', 1, array(
             'type' => 'integer',
             'default' => 1,
             'length' => 1,
             ));

        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('Category as Subcategories', array(
             'refClass' => 'ArticleCategory',
             'local' => 'category_id',
             'foreign' => 'subcategory_id'));

        $this->hasOne('Layout', array(
             'local' => 'layout_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('Article as Articles', array(
             'refClass' => 'ArticleCategory',
             'local' => 'category_id',
             'foreign' => 'article_id'));

        $this->hasMany('Category', array(
             'refClass' => 'ArticleCategory',
             'local' => 'subcategory_id',
             'foreign' => 'category_id'));

        $this->hasMany('ArticleCategory as articleCategories', array(
             'local' => 'id',
             'foreign' => 'category_id'));

        $this->hasMany('ArticleCategory as articleSubcategories', array(
             'local' => 'id',
             'foreign' => 'subcategory_id'));

        $i18n0 = new Doctrine_Template_I18n(array(
             'fields' => 
             array(
              0 => 'name',
              1 => 'description',
             ),
             ));
        $sluggable1 = new Doctrine_Template_Sluggable(array(
             'fields' => 
             array(
              0 => 'name',
             ),
             'uniqueBy' => 
             array(
              0 => 'lang',
              1 => 'name',
             ),
             'canUpdate' => true,
             'builder' => 
             array(
              0 => 'Slug',
              1 => 'slugifySchemaCategory',
             ),
             ));
        $i18n0->addChild($sluggable1);
        $this->actAs($i18n0);
    }
}