<?php


abstract class BaseMenuItem extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('menu_item');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('menu_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('submenu_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('title', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('url', 'string', 500, array(
             'type' => 'string',
             'length' => 500,
             ));
        $this->hasColumn('url_type', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('order', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('json', 'string', 1000, array(
             'type' => 'string',
             'length' => 1000,
             ));


        $this->index('fk_menu_item_menu_id1', array(
             'fields' => 
             array(
              0 => 'menu_id',
             ),
             ));
        $this->index('fk_menu_item_submenu_id1', array(
             'fields' => 
             array(
              0 => 'submenu_id',
             ),
             ));
        $this->index('fk_menu_item_unique_order_menu_id1', array(
             'fields' => 
             array(
              0 => 'menu_id',
              1 => 'order',
             ),
             'type' => 'unique',
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('MenuGroup as Menu', array(
             'local' => 'menu_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('MenuGroup as Submenu', array(
             'local' => 'submenu_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $i18n0 = new Doctrine_Template_I18n(array(
             'fields' => 
             array(
              0 => 'title',
              1 => 'url',
             ),
             ));
        $this->actAs($timestampable0);
        $this->actAs($i18n0);
    }
}