<?php


abstract class BaseArtConfiguration extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('art_configuration');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('label', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('hint', 'clob', 65535, array(
             'type' => 'clob',
             'length' => 65535,
             ));
        $this->hasColumn('name', 'clob', 65535, array(
             'type' => 'clob',
             'notnull' => true,
             'length' => 65535,
             ));
        $this->hasColumn('value', 'clob', 65535, array(
             'type' => 'clob',
             'notnull' => true,
             'length' => 65535,
             ));
        $this->hasColumn('editable', 'integer', 1, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 1,
             'length' => 1,
             ));
        $this->hasColumn('widget', 'clob', 65535, array(
             'type' => 'clob',
             'length' => 65535,
             ));
        $this->hasColumn('validator', 'clob', 65535, array(
             'type' => 'clob',
             'length' => 65535,
             ));
        $this->hasColumn('renderer', 'clob', 65535, array(
             'type' => 'clob',
             'length' => 65535,
             ));
        $this->hasColumn('default', 'clob', 65535, array(
             'type' => 'clob',
             'length' => 65535,
             ));
        $this->hasColumn('order', 'integer', 4, array(
             'type' => 'integer',
             'unique' => true,
             'length' => 4,
             ));

        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $timestampable0 = new Doctrine_Template_Timestampable();
        $i18n0 = new Doctrine_Template_I18n(array(
             'fields' => 
             array(
              0 => 'hint',
              1 => 'label',
              2 => 'value',
             ),
             ));
        $this->actAs($timestampable0);
        $this->actAs($i18n0);
    }
}