<?php


abstract class BaseLayout extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('layout');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('module', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('view', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('description', 'string', 1000, array(
             'type' => 'string',
             'length' => 1000,
             ));

        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('MessageCenter as messageCenters', array(
             'local' => 'id',
             'foreign' => 'layout_id'));

        $this->hasMany('Article as articles', array(
             'local' => 'id',
             'foreign' => 'layout_id'));

        $this->hasMany('Category as categories', array(
             'local' => 'id',
             'foreign' => 'layout_id'));

        $this->hasMany('LayoutParam as layoutParams', array(
             'local' => 'id',
             'foreign' => 'layout_id'));
    }
}