<?php


abstract class BaseLayoutParam extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('layout_param');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('layout_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => false,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('value', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));


        $this->index('fk_layout_param_layout', array(
             'fields' => 
             array(
              0 => 'layout_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Layout', array(
             'local' => 'layout_id',
             'foreign' => 'id',
             'owningSide' => true));
    }
}