<?php


abstract class BaseBlacklist extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('friend_blacklist');
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));
        $this->hasColumn('ignored_user_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));


        $this->index('fk_sf_guard_user_has_sf_guard_user_sf_guard_user2', array(
             'fields' => 
             array(
              0 => 'ignored_user_id',
             ),
             ));
        $this->index('fk_sf_guard_user_has_sf_guard_user_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('sfGuardUser as IgnoredUser', array(
             'local' => 'ignored_user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));
    }
}