<?php


abstract class BaseInternalCategory extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('internal_category');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('name', 'string', 45, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 45,
             ));
        $this->hasColumn('order', 'integer', 1, array(
             'type' => 'integer',
             'default' => 1,
             'length' => 1,
             ));


        $this->index('fk_internal_category_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('sfGuardUser as Users', array(
             'refClass' => 'InternalMessageCategory',
             'local' => 'internal_category_id',
             'foreign' => 'user_id'));

        $this->hasMany('InternalMessage as InternalMessages', array(
             'refClass' => 'InternalMessageCategory',
             'local' => 'internal_category_id',
             'foreign' => 'internal_message_id'));

        $this->hasMany('InternalMessageCategory as internalMessageCategories', array(
             'local' => 'id',
             'foreign' => 'internal_category_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}