<?php


abstract class BaseInternalConversation extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('internal_conversation');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('title', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));

        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('InternalMessage as internalMessages', array(
             'local' => 'id',
             'foreign' => 'internal_conversation_id'));
    }
}