<?php


abstract class BaseInternalMessage extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('internal_message');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('internal_conversation_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('author_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('receiver_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('is_readed', 'integer', 1, array(
             'type' => 'integer',
             'default' => 0,
             'length' => 1,
             ));
        $this->hasColumn('title', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('description', 'clob', 65535, array(
             'type' => 'clob',
             'length' => 65535,
             ));


        $this->index('fk_internal_message_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'author_id',
             ),
             ));
        $this->index('fk_internal_message_sf_guard_user2', array(
             'fields' => 
             array(
              0 => 'receiver_id',
             ),
             ));
        $this->index('fk_internal_message_internal_conversation1', array(
             'fields' => 
             array(
              0 => 'internal_conversation_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser as sfGuardAuthor', array(
             'local' => 'author_id',
             'foreign' => 'id',
             'onDelete' => 'set null',
             'onUpdate' => 'set null',
             'owningSide' => true));

        $this->hasOne('sfGuardUser', array(
             'local' => 'receiver_id',
             'foreign' => 'id',
             'onDelete' => 'set null',
             'onUpdate' => 'set null',
             'owningSide' => true));

        $this->hasOne('InternalConversation', array(
             'local' => 'internal_conversation_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('InternalCategory as InternalCategories', array(
             'refClass' => 'InternalMessageCategory',
             'local' => 'internal_message_id',
             'foreign' => 'internal_category_id'));

        $this->hasMany('sfGuardUser as Users', array(
             'refClass' => 'InternalMessageCategory',
             'local' => 'internal_message_id',
             'foreign' => 'user_id'));

        $this->hasMany('InternalMessageCategory as internalMessageCategories', array(
             'local' => 'id',
             'foreign' => 'internal_message_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}