<?php


abstract class BaseInternalMessageCategory extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('internal_message_category');
        $this->hasColumn('internal_message_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));
        $this->hasColumn('internal_category_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));


        $this->index('fk_internal_message_has_internal_category_internal_category1', array(
             'fields' => 
             array(
              0 => 'internal_category_id',
             ),
             ));
        $this->index('fk_internal_message_has_internal_category_internal_message1', array(
             'fields' => 
             array(
              0 => 'internal_message_id',
             ),
             ));
        $this->index('fk_internal_message_internal_category_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('InternalMessage', array(
             'local' => 'internal_message_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('InternalCategory', array(
             'local' => 'internal_category_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('sfGuardUser', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));
    }
}