<?php


abstract class BaseMessageCenter extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('message_center');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('message_channel_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('layout_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('collector_class', 'string', 100, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 100,
             ));
        $this->hasColumn('newsletter', 'integer', 1, array(
             'type' => 'integer',
             'default' => 0,
             'length' => 1,
             ));
        $this->hasColumn('unique_name', 'string', 45, array(
             'type' => 'string',
             'length' => 45,
             ));


        $this->index('fk_message_center_message_channel', array(
             'fields' => 
             array(
              0 => 'message_channel_id',
             ),
             ));
        $this->index('fk_message_center_layout1', array(
             'fields' => 
             array(
              0 => 'layout_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('MessageChannel', array(
             'local' => 'message_channel_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('Layout', array(
             'local' => 'layout_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('sfGuardUser as Users', array(
             'refClass' => 'UserMessageSetting',
             'local' => 'message_center_id',
             'foreign' => 'user_id'));

        $this->hasMany('MessageTemplate as messageTemplates', array(
             'local' => 'id',
             'foreign' => 'message_center_id'));

        $this->hasMany('UserMessageSetting as userMessageSettings', array(
             'local' => 'id',
             'foreign' => 'message_center_id'));

        $this->hasMany('MessageCenterFile as messageCenterFiles', array(
             'local' => 'id',
             'foreign' => 'message_center_id'));

        $this->hasMany('MessageMultisendList as messageMultisendLists', array(
             'local' => 'id',
             'foreign' => 'message_center_id'));

        $this->hasMany('MessageMultisendHistory as messageMultisendHistories', array(
             'local' => 'id',
             'foreign' => 'message_center_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}