<?php


abstract class BaseMessageChannel extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('message_channel');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('channel', 'string', 45, array(
             'type' => 'string',
             'length' => 45,
             ));
        $this->hasColumn('channel_class', 'string', 45, array(
             'type' => 'string',
             'length' => 45,
             ));

        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('MessageCenter as messageCenters', array(
             'local' => 'id',
             'foreign' => 'message_channel_id'));
    }
}