<?php


abstract class BaseMessageMultisendList extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('message_multisend_list');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('message_center_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('message_multisend_type_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('newsletter_user_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));


        $this->index('fk_message_multisend_list_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->index('fk_message_multisend_list_newsletter_user1', array(
             'fields' => 
             array(
              0 => 'newsletter_user_id',
             ),
             ));
        $this->index('fk_message_multisend_list_message_center1', array(
             'fields' => 
             array(
              0 => 'message_center_id',
             ),
             ));
        $this->index('fk_message_multisend_list_message_multisend_type1', array(
             'fields' => 
             array(
              0 => 'message_multisend_type_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('NewsletterUser', array(
             'local' => 'newsletter_user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('MessageCenter', array(
             'local' => 'message_center_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('MessageMultisendType', array(
             'local' => 'message_multisend_type_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}