<?php


abstract class BaseMessageMultisendType extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('message_multisend_type');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));

        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('MessageMultisendList as messageMultisendLists', array(
             'local' => 'id',
             'foreign' => 'message_multisend_type_id'));

        $this->hasMany('MessageMultisendHistory as messageMultisendHistories', array(
             'local' => 'id',
             'foreign' => 'message_multisend_type_id'));
    }
}