<?php


abstract class BaseNewsletterUser extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('newsletter_user');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'unique' => true,
             'length' => 8,
             ));
        $this->hasColumn('email', 'string', 100, array(
             'type' => 'string',
             'unique' => true,
             'length' => 100,
             ));
        $this->hasColumn('first_name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('last_name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('status', 'integer', 1, array(
             'type' => 'integer',
             'default' => 0,
             'length' => 1,
             ));
        $this->hasColumn('message_count', 'integer', 4, array(
             'type' => 'integer',
             'default' => 0,
             'length' => 4,
             ));


        $this->index('fk_newsletter_user_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('MessageMultisendList as messageMultisendLists', array(
             'local' => 'id',
             'foreign' => 'newsletter_user_id'));

        $this->hasMany('MessageMultisendHistory as messageMultisendHistories', array(
             'local' => 'id',
             'foreign' => 'newsletter_user_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}