<?php


abstract class BaseClassUser extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('class_has_user');
        $this->hasColumn('class_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));


        $this->index('fk_class_has_sf_guard_user_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->index('fk_class_has_sf_guard_user_class1', array(
             'fields' => 
             array(
              0 => 'class_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('TeacherClass', array(
             'local' => 'class_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('sfGuardUser as User', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));
    }
}