<?php


abstract class BaseGame extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('game');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('teacher_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 255,
             ));
        $this->hasColumn('status', 'integer', 1, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 0,
             'length' => 1,
             ));
        $this->hasColumn('game_data_json', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('game_controller_class', 'string', 125, array(
             'type' => 'string',
             'length' => 125,
             ));


        $this->index('fk_game_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'teacher_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser as Teacher', array(
             'local' => 'teacher_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('UserDetail as UserDetails', array(
             'local' => 'id',
             'foreign' => 'game_id'));

        $this->hasMany('GameTeacherPermission as game_teacher_permissions', array(
             'local' => 'id',
             'foreign' => 'game_id'));

        $this->hasMany('Team as teams', array(
             'local' => 'id',
             'foreign' => 'game_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}