<?php


abstract class BaseGameTeacherPermission extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('game_teacher_permission');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('sf_guard_user_permission_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('game_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('teacher_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));


        $this->index('fk_game_teacher_permission_sf_guard_user_permission1', array(
             'fields' => 
             array(
              0 => 'sf_guard_user_permission_id',
             ),
             ));
        $this->index('fk_game_teacher_permission_game1', array(
             'fields' => 
             array(
              0 => 'game_id',
             ),
             ));
        $this->index('fk_game_teacher_permission_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'teacher_id',
             ),
             ));
        $this->index('unique_game_teacher_permission', array(
             'fields' => 
             array(
              'sf_guard_user_permission_id' => 
              array(
              'sorting' => 'ASC',
              ),
              'game_id' => 
              array(
              'sorting' => 'ASC',
              ),
              'teacher_id' => 
              array(
              'sorting' => 'ASC',
              ),
             ),
             'type' => 'unique',
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardPermission as sfGuardUserPermission', array(
             'local' => 'sf_guard_user_permission_id',
             'foreign' => 'id'));

        $this->hasOne('Game', array(
             'local' => 'game_id',
             'foreign' => 'id'));

        $this->hasOne('sfGuardUser as Teacher', array(
             'local' => 'teacher_id',
             'foreign' => 'id'));
    }
}