<?php

/**
 * BaseMenuItem
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $menu_id
 * @property integer $submenu_id
 * @property string $title
 * @property string $url
 * @property integer $url_type
 * @property integer $order
 * @property string $json
 * @property MenuGroup $Menu
 * @property MenuGroup $Submenu
 * 
 * @method integer   getId()         Returns the current record's "id" value
 * @method integer   getMenuId()     Returns the current record's "menu_id" value
 * @method integer   getSubmenuId()  Returns the current record's "submenu_id" value
 * @method string    getTitle()      Returns the current record's "title" value
 * @method string    getUrl()        Returns the current record's "url" value
 * @method integer   getUrlType()    Returns the current record's "url_type" value
 * @method integer   getOrder()      Returns the current record's "order" value
 * @method string    getJson()       Returns the current record's "json" value
 * @method MenuGroup getMenu()       Returns the current record's "Menu" value
 * @method MenuGroup getSubmenu()    Returns the current record's "Submenu" value
 * @method MenuItem  setId()         Sets the current record's "id" value
 * @method MenuItem  setMenuId()     Sets the current record's "menu_id" value
 * @method MenuItem  setSubmenuId()  Sets the current record's "submenu_id" value
 * @method MenuItem  setTitle()      Sets the current record's "title" value
 * @method MenuItem  setUrl()        Sets the current record's "url" value
 * @method MenuItem  setUrlType()    Sets the current record's "url_type" value
 * @method MenuItem  setOrder()      Sets the current record's "order" value
 * @method MenuItem  setJson()       Sets the current record's "json" value
 * @method MenuItem  setMenu()       Sets the current record's "Menu" value
 * @method MenuItem  setSubmenu()    Sets the current record's "Submenu" value
 * 
 * @package    hotel
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseMenuItem extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('menu_item');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('menu_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('submenu_id', 'integer', 8, array(
             'type' => 'integer',
             'length' => 8,
             ));
        $this->hasColumn('title', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('url', 'string', 500, array(
             'type' => 'string',
             'length' => 500,
             ));
        $this->hasColumn('url_type', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('order', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('json', 'string', 1000, array(
             'type' => 'string',
             'length' => 1000,
             ));


        $this->index('fk_menu_item_menu_id1', array(
             'fields' => 
             array(
              0 => 'menu_id',
             ),
             ));
        $this->index('fk_menu_item_submenu_id1', array(
             'fields' => 
             array(
              0 => 'submenu_id',
             ),
             ));
        $this->index('fk_menu_item_unique_order_menu_id1', array(
             'fields' => 
             array(
              0 => 'menu_id',
              1 => 'order',
             ),
             'type' => 'unique',
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('MenuGroup as Menu', array(
             'local' => 'menu_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('MenuGroup as Submenu', array(
             'local' => 'submenu_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $i18n0 = new Doctrine_Template_I18n(array(
             'fields' => 
             array(
              0 => 'title',
              1 => 'url',
             ),
             ));
        $this->actAs($timestampable0);
        $this->actAs($i18n0);
    }
}