<?php


abstract class BaseRound extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('round');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('team_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('round_number', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('status', 'integer', 1, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 0,
             'length' => 1,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('round_data_json', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('round_decision_data_json', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('round_raport_data_json', 'clob', null, array(
             'type' => 'clob',
             ));


        $this->index('fk_round_team1', array(
             'fields' => 
             array(
              0 => 'team_id',
             ),
             ));
        $this->index('unique_round_team', array(
             'fields' => 
             array(
              'team_id' => 
              array(
              'sorting' => 'ASC',
              ),
              'round_number' => 
              array(
              'sorting' => 'ASC',
              ),
             ),
             'type' => 'unique',
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Team', array(
             'local' => 'team_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('Message as messages', array(
             'local' => 'id',
             'foreign' => 'round_id'));

        $this->hasMany('LogDecision as log_decisions', array(
             'local' => 'id',
             'foreign' => 'round_id'));

        $this->hasMany('LogEvent', array(
             'local' => 'id',
             'foreign' => 'round_id'));

        $timestampable0 = new Doctrine_Template_Timestampable(array(
             'updated' => 
             array(
              'disabled' => true,
             ),
             ));
        $this->actAs($timestampable0);
    }
}