<?php


abstract class BaseTeacherClass extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('teacher_class');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('teacher_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 255,
             ));
        $this->hasColumn('status', 'integer', 1, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 1,
             'length' => 1,
             ));


        $this->index('fk_class_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'teacher_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser as Teacher', array(
             'local' => 'teacher_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('sfGuardUser as Users', array(
             'refClass' => 'ClassUser',
             'local' => 'class_id',
             'foreign' => 'user_id'));

        $this->hasMany('ClassUser as class_has_users', array(
             'local' => 'id',
             'foreign' => 'class_id'));
    }
}