<?php


abstract class BaseTeam extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('team');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 8,
             ));
        $this->hasColumn('game_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 8,
             ));
        $this->hasColumn('max_users', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 1,
             'length' => 8,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 255,
             ));
        $this->hasColumn('logo', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));


        $this->index('fk_team_game1', array(
             'fields' => 
             array(
              0 => 'game_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Game', array(
             'local' => 'game_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasMany('sfGuardUser as Users', array(
             'refClass' => 'UserTeam',
             'local' => 'team_id',
             'foreign' => 'user_id'));

        $this->hasMany('Round as rounds', array(
             'local' => 'id',
             'foreign' => 'team_id'));

        $this->hasMany('UserTeam as user_has_teams', array(
             'local' => 'id',
             'foreign' => 'team_id'));

        $this->hasMany('Message as messages', array(
             'local' => 'id',
             'foreign' => 'team_id'));

        $this->hasMany('LogEvent', array(
             'local' => 'id',
             'foreign' => 'team_id'));
    }
}