<?php


abstract class BaseUserDetail extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('user_detail');
        $this->hasColumn('id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));
        $this->hasColumn('school', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('game_id', 'integer', 8, array(
             'type' => 'integer',
             'notnull' => false,
             'length' => 8,
             ));
        $this->hasColumn('phone', 'string', 45, array(
             'type' => 'string',
             'length' => 45,
             ));
        $this->hasColumn('status', 'integer', 1, array(
             'type' => 'integer',
             'length' => 1,
             ));
        $this->hasColumn('teacher_survey_before', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('teacher_survey_after', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('student_survey_before', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('student_survey_after', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('student_test_before', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('student_test_after', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('teacher_test_grade_before', 'clob', null, array(
             'type' => 'clob',
             ));
        $this->hasColumn('teacher_test_grade_after', 'clob', null, array(
             'type' => 'clob',
             ));


        $this->index('fk_user_detail_game1', array(
             'fields' => 
             array(
              0 => 'game_id',
             ),
             ));
        $this->index('fk_user_detail_sf_guard_user', array(
             'fields' => 
             array(
              0 => 'id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser as id', array(
             'local' => 'id',
             'foreign' => 'id'));

        $this->hasOne('Game', array(
             'local' => 'game_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));
    }
}