<?php


abstract class BaseUserTeam extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('user_has_team');
        $this->hasColumn('user_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));
        $this->hasColumn('team_id', 'integer', 8, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 8,
             ));
        $this->hasColumn('role', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));


        $this->index('fk_sf_guard_user_has_team_team1', array(
             'fields' => 
             array(
              0 => 'team_id',
             ),
             ));
        $this->index('fk_sf_guard_user_has_team_sf_guard_user1', array(
             'fields' => 
             array(
              0 => 'user_id',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser as User', array(
             'local' => 'user_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));

        $this->hasOne('Team', array(
             'local' => 'team_id',
             'foreign' => 'id',
             'onDelete' => 'cascade',
             'onUpdate' => 'cascade',
             'owningSide' => true));
    }
}