<?php

/**
 * BasesfGuardUser
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property string $first_name
 * @property string $last_name
 * @property string $email_address
 * @property string $username
 * @property string $algorithm
 * @property string $salt
 * @property string $password
 * @property boolean $is_active
 * @property boolean $is_banned
 * @property boolean $is_super_admin
 * @property timestamp $last_login
 * @property timestamp $password_expired
 * @property Doctrine_Collection $Groups
 * @property Doctrine_Collection $Permissions
 * @property Doctrine_Collection $Teams
 * @property Doctrine_Collection $sfGuardUserPermission
 * @property Doctrine_Collection $sfGuardUserGroup
 * @property sfGuardRememberKey $RememberKeys
 * @property sfGuardForgotPassword $ForgotPassword
 * @property Doctrine_Collection $MessageCenters
 * @property Doctrine_Collection $userMessageSettings
 * @property Doctrine_Collection $friendshipOwner
 * @property Doctrine_Collection $friend
 * @property Doctrine_Collection $blacklists
 * @property Doctrine_Collection $internalMessages
 * @property Doctrine_Collection $InternalMessages
 * @property Doctrine_Collection $internalCategories
 * @property Doctrine_Collection $InternalCategoriesThroughInternalMessageCategory
 * @property Doctrine_Collection $internalMessageCategories
 * @property Doctrine_Collection $newsletterUsers
 * @property Doctrine_Collection $messageMultisendLists
 * @property Doctrine_Collection $messageMultisendHistories
 * @property Doctrine_Collection $articles
 * @property Doctrine_Collection $articleComments
 * @property Doctrine_Collection $invitations
 * @property Doctrine_Collection $user_details
 * @property Doctrine_Collection $teacher_classes
 * @property Doctrine_Collection $Users
 * @property Doctrine_Collection $games
 * @property Doctrine_Collection $game_teacher_permissions
 * @property Doctrine_Collection $class_has_users
 * @property Doctrine_Collection $user_has_teams
 * @property Doctrine_Collection $messages
 * @property Doctrine_Collection $user_log_decisions
 * @property Doctrine_Collection $log_events
 * 
 * @method string                getFirstName()                                        Returns the current record's "first_name" value
 * @method string                getLastName()                                         Returns the current record's "last_name" value
 * @method string                getEmailAddress()                                     Returns the current record's "email_address" value
 * @method string                getUsername()                                         Returns the current record's "username" value
 * @method string                getAlgorithm()                                        Returns the current record's "algorithm" value
 * @method string                getSalt()                                             Returns the current record's "salt" value
 * @method string                getPassword()                                         Returns the current record's "password" value
 * @method boolean               getIsActive()                                         Returns the current record's "is_active" value
 * @method boolean               getIsBanned()                                         Returns the current record's "is_banned" value
 * @method boolean               getIsSuperAdmin()                                     Returns the current record's "is_super_admin" value
 * @method timestamp             getLastLogin()                                        Returns the current record's "last_login" value
 * @method timestamp             getPasswordExpired()                                  Returns the current record's "password_expired" value
 * @method Doctrine_Collection   getGroups()                                           Returns the current record's "Groups" collection
 * @method Doctrine_Collection   getPermissions()                                      Returns the current record's "Permissions" collection
 * @method Doctrine_Collection   getTeams()                                            Returns the current record's "Teams" collection
 * @method Doctrine_Collection   getSfGuardUserPermission()                            Returns the current record's "sfGuardUserPermission" collection
 * @method Doctrine_Collection   getSfGuardUserGroup()                                 Returns the current record's "sfGuardUserGroup" collection
 * @method sfGuardRememberKey    getRememberKeys()                                     Returns the current record's "RememberKeys" value
 * @method sfGuardForgotPassword getForgotPassword()                                   Returns the current record's "ForgotPassword" value
 * @method Doctrine_Collection   getMessageCenters()                                   Returns the current record's "MessageCenters" collection
 * @method Doctrine_Collection   getUserMessageSettings()                              Returns the current record's "userMessageSettings" collection
 * @method Doctrine_Collection   getFriendshipOwner()                                  Returns the current record's "friendshipOwner" collection
 * @method Doctrine_Collection   getFriend()                                           Returns the current record's "friend" collection
 * @method Doctrine_Collection   getBlacklists()                                       Returns the current record's "blacklists" collection
 * @method Doctrine_Collection   getInternalMessages()                                 Returns the current record's "internalMessages" collection
 * @method Doctrine_Collection   getInternalMessages()                                 Returns the current record's "InternalMessages" collection
 * @method Doctrine_Collection   getInternalCategories()                               Returns the current record's "internalCategories" collection
 * @method Doctrine_Collection   getInternalCategoriesThroughInternalMessageCategory() Returns the current record's "InternalCategoriesThroughInternalMessageCategory" collection
 * @method Doctrine_Collection   getInternalMessageCategories()                        Returns the current record's "internalMessageCategories" collection
 * @method Doctrine_Collection   getNewsletterUsers()                                  Returns the current record's "newsletterUsers" collection
 * @method Doctrine_Collection   getMessageMultisendLists()                            Returns the current record's "messageMultisendLists" collection
 * @method Doctrine_Collection   getMessageMultisendHistories()                        Returns the current record's "messageMultisendHistories" collection
 * @method Doctrine_Collection   getArticles()                                         Returns the current record's "articles" collection
 * @method Doctrine_Collection   getArticleComments()                                  Returns the current record's "articleComments" collection
 * @method Doctrine_Collection   getInvitations()                                      Returns the current record's "invitations" collection
 * @method Doctrine_Collection   getUserDetails()                                      Returns the current record's "user_details" collection
 * @method Doctrine_Collection   getTeacherClasses()                                   Returns the current record's "teacher_classes" collection
 * @method Doctrine_Collection   getUsers()                                            Returns the current record's "Users" collection
 * @method Doctrine_Collection   getGames()                                            Returns the current record's "games" collection
 * @method Doctrine_Collection   getGameTeacherPermissions()                           Returns the current record's "game_teacher_permissions" collection
 * @method Doctrine_Collection   getClassHasUsers()                                    Returns the current record's "class_has_users" collection
 * @method Doctrine_Collection   getUserHasTeams()                                     Returns the current record's "user_has_teams" collection
 * @method Doctrine_Collection   getMessages()                                         Returns the current record's "messages" collection
 * @method Doctrine_Collection   getUserLogDecisions()                                 Returns the current record's "user_log_decisions" collection
 * @method Doctrine_Collection   getLogEvents()                                        Returns the current record's "log_events" collection
 * @method sfGuardUser           setFirstName()                                        Sets the current record's "first_name" value
 * @method sfGuardUser           setLastName()                                         Sets the current record's "last_name" value
 * @method sfGuardUser           setEmailAddress()                                     Sets the current record's "email_address" value
 * @method sfGuardUser           setUsername()                                         Sets the current record's "username" value
 * @method sfGuardUser           setAlgorithm()                                        Sets the current record's "algorithm" value
 * @method sfGuardUser           setSalt()                                             Sets the current record's "salt" value
 * @method sfGuardUser           setPassword()                                         Sets the current record's "password" value
 * @method sfGuardUser           setIsActive()                                         Sets the current record's "is_active" value
 * @method sfGuardUser           setIsBanned()                                         Sets the current record's "is_banned" value
 * @method sfGuardUser           setIsSuperAdmin()                                     Sets the current record's "is_super_admin" value
 * @method sfGuardUser           setLastLogin()                                        Sets the current record's "last_login" value
 * @method sfGuardUser           setPasswordExpired()                                  Sets the current record's "password_expired" value
 * @method sfGuardUser           setGroups()                                           Sets the current record's "Groups" collection
 * @method sfGuardUser           setPermissions()                                      Sets the current record's "Permissions" collection
 * @method sfGuardUser           setTeams()                                            Sets the current record's "Teams" collection
 * @method sfGuardUser           setSfGuardUserPermission()                            Sets the current record's "sfGuardUserPermission" collection
 * @method sfGuardUser           setSfGuardUserGroup()                                 Sets the current record's "sfGuardUserGroup" collection
 * @method sfGuardUser           setRememberKeys()                                     Sets the current record's "RememberKeys" value
 * @method sfGuardUser           setForgotPassword()                                   Sets the current record's "ForgotPassword" value
 * @method sfGuardUser           setMessageCenters()                                   Sets the current record's "MessageCenters" collection
 * @method sfGuardUser           setUserMessageSettings()                              Sets the current record's "userMessageSettings" collection
 * @method sfGuardUser           setFriendshipOwner()                                  Sets the current record's "friendshipOwner" collection
 * @method sfGuardUser           setFriend()                                           Sets the current record's "friend" collection
 * @method sfGuardUser           setBlacklists()                                       Sets the current record's "blacklists" collection
 * @method sfGuardUser           setInternalMessages()                                 Sets the current record's "internalMessages" collection
 * @method sfGuardUser           setInternalMessages()                                 Sets the current record's "InternalMessages" collection
 * @method sfGuardUser           setInternalCategories()                               Sets the current record's "internalCategories" collection
 * @method sfGuardUser           setInternalCategoriesThroughInternalMessageCategory() Sets the current record's "InternalCategoriesThroughInternalMessageCategory" collection
 * @method sfGuardUser           setInternalMessageCategories()                        Sets the current record's "internalMessageCategories" collection
 * @method sfGuardUser           setNewsletterUsers()                                  Sets the current record's "newsletterUsers" collection
 * @method sfGuardUser           setMessageMultisendLists()                            Sets the current record's "messageMultisendLists" collection
 * @method sfGuardUser           setMessageMultisendHistories()                        Sets the current record's "messageMultisendHistories" collection
 * @method sfGuardUser           setArticles()                                         Sets the current record's "articles" collection
 * @method sfGuardUser           setArticleComments()                                  Sets the current record's "articleComments" collection
 * @method sfGuardUser           setInvitations()                                      Sets the current record's "invitations" collection
 * @method sfGuardUser           setUserDetails()                                      Sets the current record's "user_details" collection
 * @method sfGuardUser           setTeacherClasses()                                   Sets the current record's "teacher_classes" collection
 * @method sfGuardUser           setUsers()                                            Sets the current record's "Users" collection
 * @method sfGuardUser           setGames()                                            Sets the current record's "games" collection
 * @method sfGuardUser           setGameTeacherPermissions()                           Sets the current record's "game_teacher_permissions" collection
 * @method sfGuardUser           setClassHasUsers()                                    Sets the current record's "class_has_users" collection
 * @method sfGuardUser           setUserHasTeams()                                     Sets the current record's "user_has_teams" collection
 * @method sfGuardUser           setMessages()                                         Sets the current record's "messages" collection
 * @method sfGuardUser           setUserLogDecisions()                                 Sets the current record's "user_log_decisions" collection
 * @method sfGuardUser           setLogEvents()                                        Sets the current record's "log_events" collection
 * 
 * @package    hotel
 * @subpackage model

 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BasesfGuardUser extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('sf_guard_user');
        $this->hasColumn('first_name', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('last_name', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('email_address', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'unique' => true,
             'length' => 255,
             ));
        $this->hasColumn('username', 'string', 128, array(
             'type' => 'string',
             'notnull' => true,
             'unique' => true,
             'length' => 128,
             ));
        $this->hasColumn('algorithm', 'string', 128, array(
             'type' => 'string',
             'default' => 'sha1',
             'notnull' => true,
             'length' => 128,
             ));
        $this->hasColumn('salt', 'string', 128, array(
             'type' => 'string',
             'length' => 128,
             ));
        $this->hasColumn('password', 'string', 128, array(
             'type' => 'string',
             'length' => 128,
             ));
        $this->hasColumn('is_active', 'boolean', null, array(
             'type' => 'boolean',
             'default' => 0,
             ));
        $this->hasColumn('is_banned', 'boolean', null, array(
             'type' => 'boolean',
             'default' => 0,
             ));
        $this->hasColumn('is_super_admin', 'boolean', null, array(
             'type' => 'boolean',
             'default' => false,
             ));
        $this->hasColumn('last_login', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
        $this->hasColumn('password_expired', 'timestamp', null, array(
             'type' => 'timestamp',
             ));


        $this->index('is_active_idx', array(
             'fields' => 
             array(
              0 => 'is_active',
             ),
             ));
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
        $this->option('type', 'InnoDB');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('sfGuardGroup as Groups', array(
             'refClass' => 'sfGuardUserGroup',
             'local' => 'user_id',
             'foreign' => 'group_id'));

        $this->hasMany('sfGuardPermission as Permissions', array(
             'refClass' => 'sfGuardUserPermission',
             'local' => 'user_id',
             'foreign' => 'permission_id'));

        $this->hasMany('Team as Teams', array(
             'refClass' => 'UserTeam',
             'local' => 'user_id',
             'foreign' => 'team_id'));

        $this->hasMany('sfGuardUserPermission', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('sfGuardUserGroup', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasOne('sfGuardRememberKey as RememberKeys', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasOne('sfGuardForgotPassword as ForgotPassword', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('MessageCenter as MessageCenters', array(
             'refClass' => 'UserMessageSetting',
             'local' => 'user_id',
             'foreign' => 'message_center_id'));

        $this->hasMany('UserMessageSetting as userMessageSettings', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('Friend as friendshipOwner', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('Friend as friend', array(
             'local' => 'id',
             'foreign' => 'friend_id'));

        $this->hasMany('Blacklist as blacklists', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('InternalMessage as internalMessages', array(
             'local' => 'id',
             'foreign' => 'author_id'));

        $this->hasMany('InternalMessage as InternalMessages', array(
             'refClass' => 'InternalMessageCategory',
             'local' => 'user_id',
             'foreign' => 'internal_message_id'));

        $this->hasMany('InternalCategory as internalCategories', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('InternalCategory as InternalCategoriesThroughInternalMessageCategory', array(
             'refClass' => 'InternalMessageCategory',
             'local' => 'user_id',
             'foreign' => 'internal_category_id'));

        $this->hasMany('InternalMessageCategory as internalMessageCategories', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('NewsletterUser as newsletterUsers', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('MessageMultisendList as messageMultisendLists', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('MessageMultisendHistory as messageMultisendHistories', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('Article as articles', array(
             'local' => 'id',
             'foreign' => 'creator_id'));

        $this->hasMany('ArticleComment as articleComments', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('Invitation as invitations', array(
             'local' => 'id',
             'foreign' => 'inviter_id'));

        $this->hasMany('UserDetail as user_details', array(
             'local' => 'id',
             'foreign' => 'id'));

        $this->hasMany('TeacherClass as teacher_classes', array(
             'local' => 'id',
             'foreign' => 'teacher_id'));

        $this->hasMany('TeacherClass as Users', array(
             'refClass' => 'ClassUser',
             'local' => 'user_id',
             'foreign' => 'class_id'));

        $this->hasMany('Game as games', array(
             'local' => 'id',
             'foreign' => 'teacher_id'));

        $this->hasMany('GameTeacherPermission as game_teacher_permissions', array(
             'local' => 'id',
             'foreign' => 'teacher_id'));

        $this->hasMany('ClassUser as class_has_users', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('UserTeam as user_has_teams', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('Message as messages', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('LogDecision as user_log_decisions', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('LogEvent as log_events', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $searchable0 = new Doctrine_Template_Searchable(array(
             'fields' => 
             array(
             ),
             'analyzer' => 'PolishSearchableAnalyzer',
             ));
        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($searchable0);
        $this->actAs($timestampable0);
    }
}