<?php

/**
 * sfGuardUser
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    hotel
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class sfGuardUser extends PluginsfGuardUser {

  const TEACHER = 0;
  const DEMO = 1;

  /**
   * Sprawdza, czy dany użytkownik należy do grupy podanej w parametrze.
   * 
   * @param int $teacherId
   * @param string $groupName nazwa grupy
   * @return boolean
   */
  public function userHasGroup($teacherId = null, $grupName = 'teacher') {
    if (is_null($teacherId)) {
      $teacherId = $this->getUser()->getId();
    }

    $query =  
            Doctrine_Core::getTable('sfGuardUserGroup')->createQuery('sgu')
                    ->where('sgu.user_id = ?', $teacherId)
                    ->leftJoin('sgu.Group g')
                    ->andWhere('g.name = ?', $grupName)->execute();
    
//    var_dump($query);

    if ($query->count() > 0) {
      return true;
    } else {
      return false;
    }
  }

  /**
   * Sprawdza, czy nauczyciel ma konto demo. GENERATOR
   */
  public function isTeacherDemo() {
    if ($this->userHasGroup($this->getId(), 'teacher_demo')) {
      return true;
    } else {
      return false;
    }
  }

  /**
   * Sprawdza, czy uczen ma uprawnienia tester
   */
  public function isTester() {
    if ($this->userHasGroup($this->getId(), 'tester')) {
      return true;
    } else {
      return false;
    }
  }

  /**
   * Sprawdza, czy uczen nie ma uprawnien testera.
   * Wykorzystywany w generatorze do wyswietlenia przycisku zmiany uzytkownika
   * ze zwyklego ucznia na testera.
   */
  public function isNotTester() {
    return !$this->isTester();
  }

  /**
   * Sprawdza, czy uzytkownik ma wygenerowane haslo. Jesli nie ma, wyswietla
   * w panelu pnUsers/paUsers przycisk do wygenerowania hasla. GENERATOR
   * 
   * @return boolean
   */
  public function noPassword() {
    $userId = $this->getId();
    $password = Doctrine::getTable('SfGuardUser')->findOneById($userId)->getPassword();

    if ($password == NULL) {
      return true;
    }
    return false;
  }

  /**
   * Zmienia grupę z 'teacher_demo' na 'teacher'
   * @param int $teacherId
   */
  public static function teacherFullActivate($teacherId = null) {
    if (is_null($teacherId)) {
      $teacherId = $this->getUser()->getId();
    }

    $userGroup = Doctrine::getTable('SfGuardUserGroup')->createQuery('sgu')
                    ->where('sgu.user_id = ?', $teacherId)
                    ->leftJoin('sgu.Group g')
                    ->andWhere('g.name = ?', 'teacher_demo')->fetchOne();

    $groupId = Doctrine::getTable('SfGuardGroup')->findOneByName('teacher')->getId();
    $userGroup->setGroupId($groupId);
    $userGroup->save();
  }
  
  /**
   * Dodaje prawa testera poprzez dodanie uzytkownika
   * do grupy 'tester'
   * 
   * @param int $userId ID Użytkownika
   */
  public static function addTester($userId) {
    $user = Doctrine::getTable('sfGuardUser')->findOneById($userId);
    $group = Doctrine::getTable('sfGuardGroup')->findOneByName('tester');
    $user->getGroups()->add($group);
    $user->save();
  }
  
  /**
   * Usuwa prawa testera poprzez usuniecie uzytkownika
   * z grupy 'tester'
   * 
   * @param int $userId ID Użytkownika
   */
  public static function deleteTester($userId) {
    $user = Doctrine::getTable('sfGuardUser')->findOneById($userId);
    $groupTranslation = Doctrine::getTable('sfGuardGroup')->findOneByName('tester');
    
    foreach ($user->getGroups() as $key => $group) {
      if ($group === $groupTranslation) {
        $user->getGroups()->remove($key);
        break;
      }
    }
    $user->save();
  }

  /**
   * Generuje haslo dla uzytkownika o ID podanym w parametrze
   * 
   * @param int $userId
   */
  public static function generatePassword($userId = null) {
    if (is_null($userId)) {
      $userId = $this->getUser()->getId();
    }
    //na razie haslem bedzie nazwa uzytkownika
    $password = Doctrine::getTable('SfGuardUser')->findOneById($userId)->getUsername();

    // aktualny uzytkownik
    $currentUser = Doctrine::getTable('SfGuardUser')->findOneById($userId);
    $currentUser->setPassword($password);
    $currentUser->save();
  }

  /**
   * Generuje hasla dla wszystkich uzytkownikow z danej klasy.
   * Poki co haslem jest nazwa uzytkownika.
   * 
   * @return array Tablica z haslami i uczniami
   */
  public static function generatePasswordForClass() {
//    wszyscy uczniowie dla danej klasy i nauczyciela
    //TO_DO cos zle pobiera uczniow
    $students = sfGuardUserTable::getUsersForTeacherAndClass();
//    $students2 = $students->getUsers();
//    echo '<pre>'; 
//    var_dump($students->toArray());
//    echo '</pre>'; 
//    die();
    
    $array = NULL;
    
    foreach ($students as $student) {
      $password = $student->getUsername();
      $array[$student->getId()] = array('password' => $password, 'student' =>$student);
      $student->setPassword($password);
    }
    $students->save();

    return $array;
  }

  /**
   * Zwraca listę zespołów do których jest przypisany użytkownik;
   *
   * @return object,
   */
  public function getTeamList() {
    return $this->getTeams();
  }
  
  public function getClassName() {
    return 'nazwa klasy';
  }
}
