<?php

/**
 * sfGuardUserTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class sfGuardUserTable extends PluginsfGuardUserTable {

  /**
   * Returns an instance of this class.
   *
   * @return object sfGuardUserTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('sfGuardUser');
  }

  public function getTeacherUsers() {
    $query = $this->createQuery('sfu')
        ->select('sfu.id, sfu.first_name, sfu.last_name, sfu.email_address, t.name, t.id, sfu.is_active, sfu.created_at, ud.game_id')
        ->leftJoin('sfu.user_details ud')
        ->leftJoin('ud.Game g')
        ->leftJoin('sfu.Teams t');

    $user = sfContext::getInstance()->getUser();
    if ($user->isTeacher()) {
      $teacherId = $user->getId();
    } else {
      $teacherId = -1;
    }

    $query->andWhere('g.teacher_id = ?', $teacherId);

    return $query;
  }

  /**
   * Pobiera uczniów dla danego nauczyciela. 
   * 
   * @return ;
   */
  public static function getUsersForTeacher($teacherId = null) {
    $query = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
        ->leftJoin('u.ClassUser chu')
        ->leftJoin('chu.TeacherClass c')
        ->leftJoin('u.sfGuardUserGroup sgu')
        ->leftJoin('sgu.Group g')
        ->where('g.name = ?', 'user');
    if (is_null($teacherId) && (sfContext::getInstance()->getUser()->isTeacher() || sfContext::getInstance()->getUser()->isTeacherDemo())) {
      $teachId = sfContext::getInstance()->getUser()->getId();
      $query->andWhere('c.teacher_id = ?', $teachId);
    }

    return $query->execute();
  }

  /**
   * Pobiera uczniów dla danej klasy. GENERATOR
   * @param int $classId id klasy
   * @return Doctrine_Query
   */
  public static function getUsersForClass($classId = false) {
    if ($classId) {
      $classId = sfContext::getInstance()->getUser()->getAttribute('class_id');
    }

    return Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
            ->leftJoin('u.ClassUser chu')
            ->where('chu.class_id = ?', $classId);
  }

  public static function getUsersForTeacherAndClass($teacherId = null) {
    $classId = sfContext::getInstance()->getUser()->getAttribute('class_id');

    if (is_null($teacherId) && (sfContext::getInstance()->getUser()->isTeacher() || sfContext::getInstance()->getUser()->isTeacherDemo())) {
      $teacherId = sfContext::getInstance()->getUser()->getId();
    }

    $query = Doctrine::getTable('sfGuardUser')
        ->createQuery('u')
        ->leftJoin('u.ClassUser cu')
        ->leftJoin('cu.TeacherClass c')
        ->where('c.teacher_id = ?', $teacherId)
        ->andWhere('c.id = ?', $classId);

    return $query->execute();
  }

  public static function getTeachers() {
    $query = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
        ->leftJoin('u.sfGuardUserGroup sgu')
        ->leftJoin('sgu.Group g')
        ->andWhereIn('g.name', array('teacher', 'teacher_demo'));

    return $query;
  }

  /**
   * Retrieves a sfGuardUser object by username or email_address and is_active flag.
   *
   * @param  string  $username The username
   * @param  boolean $isActive The user's status
   *
   * @return sfGuardUser
   */
  public function retrieveByUsernameOrEmailAddress($username, $isActive = true) {
    $query = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
        ->where('u.username = ? OR u.email_address = ?', array($username, $username));

    return $query->fetchOne();
  }

}
