<?php

/*
 * This file is part of the symfony package.
 * (c) Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 *
 * @package    symfony
 * @subpackage plugin
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfGuardValidatorUser.class.php 25546 2009-12-17 23:27:55Z Jonathan.Wage $
 */
class hotelGameNameValidator extends sfValidatorString {

  protected function configure($options = array(), $messages = array()) {
    parent::configure($options, $messages);
    $this->addMessage('game_not_exist', 'Gra "%value%" nie istnieje w systemie. Poproś nauczyciela o dokładną nazwę gry.');
    $this->addMessage('game_invalid', 'Gra "%value%" już się rozpoczeła.');

    $this->addOption('game_not_exist');
    $this->addOption('game_invalid');

  }

  protected function doClean($value) {
    $value = parent::doClean($value);

    $game = Doctrine::GetTable('Game')->findOneByName($value);
    if (!$game) {
      throw new sfValidatorError($this, 'game_not_exist', array('value' => $value, 'game_not_exist' => $this->getOption('game_not_exist')));
    } elseif (!$game->isPrepared()) {
      throw new sfValidatorError($this, 'game_invalid', array('value' => $value, 'game_not_exist' => $this->getOption('game_not_exist')));
    }

    return $value;
  }

}
