<?php

class hotelValidatorInteger extends sfValidatorBase {

    protected function configure($options = array(), $messages = array()) {
        $this->addOption('field_name', '');
        $this->addOption('greater_than');
        $this->addOption('less_than');
        $this->addOption('greater_equal_than');
        $this->addOption('less_equal_than');

        $this->addOption('min');
        $this->addOption('max');

        $this->addMessage('max', '"%value%" must be at most %max%');
        $this->addMessage('min', '"%value%" must be at least %min%');

        $this->setMessage('max', 'Maksymalna wartość pola wynosi %max%');
        $this->setMessage('min', 'Minimalna wartość pola wynosi %min%');
        $this->addMessage('greater_than', 'Wartość musi być większa niż %greater_than%');
        $this->addMessage('less_than', 'Wartość musi być mniejsza niż %less_than%');
        $this->addMessage('greater_equal_than', 'Wartośc musi być większa lub równa %greater_equal_than%');
        $this->addMessage('less_equal_than', 'Wartość musi być mniejsza lub równa %less_equal_than%');

        $this->addMessage('number', '"%value%" nie jest liczbą całkowitą.');
    }

    protected function doClean($value) {
        $clean = str_replace(',', '.', $value);
        $clean = str_replace(' ', '', $clean);
        $fieldName = $this->getOption('field_name');

        $clean = intval($value);
        
        if (strval($clean) != $value) {
            throw new sfValidatorError($this, 'number', array('value' => $value));
        }

        $clean = doubleval($clean);
        //OPTIONS:
        //min
        if ($this->hasOption('min') && $clean < $this->getOption('min'))
            throw new sfValidatorError($this, 'min', array('value' => $value, 'field_name' => $fieldName, 'min' => $this->getOption('min')));

        //max
        if ($this->hasOption('max') && $clean > $this->getOption('max'))
            throw new sfValidatorError($this, 'max', array('value' => $value, 'field_name' => $fieldName, 'max' => $this->getOption('max')));

        //less
        if ($this->hasOption('less_than') && $clean >= $this->getOption('less_than'))
            throw new sfValidatorError($this, 'less_than', array('value' => $value, 'field_name' => $fieldName, 'less_than' => $this->getOption('less_than')));

        //greater
        if ($this->hasOption('greater_than') && $clean <= $this->getOption('greater_than'))
            throw new sfValidatorError($this, 'greater_than', array('value' => $value, 'field_name' => $fieldName, 'greater_than' => $this->getOption('greater_than')));

        //less equal
        if ($this->hasOption('less_equal_than') && $clean > $this->getOption('less_equal_than'))
            throw new sfValidatorError($this, 'less_equal_than', array('value' => $value, 'field_name' => $fieldName, 'less_equal_than' => $this->getOption('less_equal_than')));

        //greater equal
        if ($this->hasOption('greater_equal_than') && $clean < $this->getOption('greater_equal_than'))
            throw new sfValidatorError($this, 'greater_equal_than', array('value' => $value, 'field_name' => $fieldName, 'greater_equal_than' => $this->getOption('greater_equal_than')));

        return $clean;
    }

    public function clean($value) {
        if ($this->getOption('field_name') != '')
            $this->setMessage('required', 'Pole "%field_name%" jest wymagane.');

        $clean = $value;

        if ($this->isEmpty($clean)) {
            if ($this->options['required'])
                throw new sfValidatorError($this, 'required', array('field_name' => $this->getOption('field_name')));

            return $this->getEmptyValue();
        }

        return $this->doClean($clean);
    }

}
