<?php


class artWidgetFormSchemaFormatter extends sfWidgetFormSchemaFormatter {

    protected
            $infoFormat = '%info%';

    /*
     * Ustawia nowy format pola formularza, dorzuca dodatkowe pola
     */

    public function formatRow($label, $field, $errors = array(), $help = '', $hiddenFields = null, $info = '') {

        $id = array('');
        $matches = array();
        preg_match('/id="(.*?)\"/', $field, $matches, PREG_OFFSET_CAPTURE);

        foreach ($matches as $match) {
            $id = $match;
        }

        $id[0] = str_replace('_', '-', $id[0]);
        $id[0] = str_replace('"', '-', $id[0]);
        $id[0] = str_replace('\'', '-', $id[0]);

        preg_match('/standard="(.*?)\"/', $field, $matches, PREG_OFFSET_CAPTURE);


        foreach ($matches as $match) {
            $st = $match;
        }

        if (!isset($st)) {
            $st[0] = 'none';
        }

        return strtr(parent::formatRow($label, $field, $errors, $help, $hiddenFields), array(
            '%is_error%' => (count($errors) > 0) ? ' error' : '',
            '%info%' => $this->formatInfo($info),
            '%class%' => $id[0],
            '%standard%' => $st[0],
        ));
    }

    /*
     * Przygotowuje nowy format elementu pola formularza
     */

    public function formatInfo($info) {
        if (!$info) {
            return '';
        }

        return strtr($this->getInfoFormat(), array('%info%' => $this->translate($info)));
    }

    /*
     * Ustawia nowy format elementu pola formularza
     */

    public function setInfoFormat($format) {
        $this->infoFormat = $format;
    }

    /*
     * Zwraca format elementu pola formularza
     */

    public function getInfoFormat() {
        return $this->infoFormat;
    }

    public function generateLabel($name, $attributes = array()) {

        return 'sdcsdfcsd';
        parent::generateLabel($name, $attributes);
    }

}
