<?php

class hotelWidgetLogo extends sfWidgetFormInputText {

    public $logoPath = "/uploads/loga/";
    
    public function configure($options = array(), $attributes = array()) {
        parent::configure($options, $attributes);

        $this->addOption('class_out_box', false);
    }
    
    public function validateValue($value) {
        $logos = $this->getLogos(true);
        return !is_null($value) && $value != '' && !in_array($value, $logos);
    }

    /**
     * @param  string $name        The element name
     * @param  string $value       The value displayed in this widget
     * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
     * @param  array  $errors      An array of errors for the field
     *
     * @return string An HTML tag string
     *
     * @see sfWidgetFormInput
     */
    public function render($name, $value = null, $attributes = array(), $errors = array()) {
        $content = parent::render($name, $value, $attributes, $errors);
        
        $content .= '<div id="logo-question" class="element-group images bg_decision_form_wybor_loga_1" onclick="$(\'#decision_form_wybor_loga\').val($(\'logo-question\').attr(\'src\'));$(\'.bg_decision_form_wybor_loga_1\').removeClass(\'active\'); $(\'#logo-question\').addClass(\'active\');">
                         <img class="logo-question" src="'.($this->validateValue($value) ? $value : $this->logoPath.'logo-question.png').'" alt="Logo">
                     </div>';
                         
        foreach ($this->getLogos() as $class => $logo) {
            $content .= '
                     <div id="'.$class.'" class="element-group images bg_decision_form_wybor_loga_1" onclick="$(\'#decision_form_wybor_loga\').val($(\'.'.$class.'\').attr(\'src\'));$(\'.bg_decision_form_wybor_loga_1\').removeClass(\'active\'); $(\'#'.$class.'\').addClass(\'active\');">
                         <img class="'.$class.'" src="'.$this->logoPath.$logo.'" alt="Logo">
                     </div>';
        }
        $content .= '
                <span class="btn btn-success fileinput-button">
                    <span>Własne logo</span>
                    <input id="fileupload" type="file" name="files[]" data-url="'.url_for('@fm_file_upload').'">
                </span>';
        $content .= '
            <script type="text/javascript">
                $(function() {
                    $("#fileupload").fileupload({
                        done: function(e, data) {
                            files = JSON.parse(data.jqXHR.responseText).files;
                            $.each(files, function(index, file) {
                                $(".decision-form-wybor-loga div.errors").remove();
                                if (typeof file.error != \'undefined\') {
                                    $("label[for=\"decision_form_wybor_loga\"").after(\'<div class="errors"><span class="w100 fl"><i class="icon-error fl"></i> \'+file.error+\'</span></div>\');
                                } else {
                                    $(".logo-question").attr("src", "/uploads/loga/"+file.name);
                                    $(".bg_decision_form_wybor_loga_1").removeClass("active");
                                    $("#logo-question").addClass("active");
                                    $("#decision_form_wybor_loga").val("'.$this->logoPath.'"+file.name);
                                }
                            });
                        }
                    });
                    $(".bg_decision_form_wybor_loga_1").each(function() {
                        if ($("img", this).attr("src") === $("#decision_form_wybor_loga").val()) {
                            $(this).addClass("active");
                        }
                    });
                });
            </script>';
        
        return $content;
    }
    
    public function getLogos($path = false) {
        return array(
           'logo-1' => ($path ? $this->logoPath : '').'logo1.png',
           'logo-2' => ($path ? $this->logoPath : '').'logo2.png',
           'logo-3' => ($path ? $this->logoPath : '').'logo3.png',
        );
    }
}

 //
 
         