<?php

class hotelWidgetMoney extends sfWidgetFormInputText {

    public function configure($options = array(), $attributes = array()) {
        parent::configure($options, $attributes);

        $this->addOption('class_out_box', false);
    }

    /**
     * @param  string $name        The element name
     * @param  string $value       The value displayed in this widget
     * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
     * @param  array  $errors      An array of errors for the field
     *
     * @return string An HTML tag string
     *
     * @see sfWidgetFormInput
     */
    public function render($name, $value = null, $attributes = array(), $errors = array()) {
        $c = $this->getOption('class_out_box') ? $this->getOption('class_out_box') : artArray::getFromArray($attributes, 'class_out_box', '');
        unset($attributes['class_out_box']);
        $attributes['data-thousands'] = " ";
        $attributes['data-decimal'] = ",";

        $content = '<div class="art_input ' . $c . '">' . artBox::beginBox('horizontal') . parent::render($name, $value, $attributes, $errors) . artBox::endBox('horizontal') . '</div>';
        
        $id = str_replace(array('['), '_', $name);
        $id = str_replace(array(']'), '', $id);
        
        $js = "\n". '<script type="text/javascript">/* <![CDATA[ */' . "\n";
        $js .= '$(function() {';
        $js .= '  $("#'.$id.'").maskMoney();';
        $js .= '  $("#'.$id.'").click();';
        $js .= '});' . "\n";
        $js .= '/* ]]> */</script>' . "\n";
        
        return $content . $js;
    }

    public function setLabel($value) {
        if ($this->getOption('required'))
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
        $this->setOption('label', $value);

        return $this;
    }

}
