<?php

class sfArtWidgetFormRadio extends sfWidgetFormSelectRadio {

  protected function configure($options = array(), $attributes = array()) {
        
    parent::configure($options, $attributes);

    $this->addOption('class', 'radio_list');
    $this->addOption('label_separator', '&nbsp;');
    $this->addOption('separator', "\n");
    $this->addOption('formatter', array($this, 'formatter'));
    $this->addOption('template', '%group% %options%');
  }

  public function render($name, $value = null, $attributes = array(), $errors = array()) {
    if ('[]' != substr($name, -2)) {
      $name .= '[]';
    }

    $choices = $this->getChoices();

    // with groups?
    if (count($choices) && is_array(next($choices))) {
      $parts = array();
      foreach ($choices as $key => $option) {
        $parts[] = strtr($this->getOption('template'), array('%group%' => $key, '%options%' => 
            $this->formatChoices($name, $value, $option, $attributes)));
      }

      return implode("\n", $parts);
    } else {
      return $this->formatChoices($name, $value, $choices, $attributes);
    }
  }

  protected function formatChoices($name, $value, $choices, $attributes) {
    $inputs = array();
    foreach ($choices as $key => $option) {
      $baseAttributes = array(
          'name' => substr($name, 0, -2),
          'type' => 'radio',
          'value' => self::escapeOnce($key),
          'id' => $id = $this->generateId($name, self::escapeOnce($key)),
      );

      if (strval($key) == strval($value === false ? 0 : $value)) {
        $baseAttributes['checked'] = 'checked';
      }

      $inputs[$id] = array(
          'input' => $this->renderTag('input', array_merge($baseAttributes, $attributes)),
          'label' => $this->renderContentTag('label', self::escapeOnce($option), array('for' => $id)),
      );
    }

    return call_user_func($this->getOption('formatter'), $this, $inputs);
  }
  
    /**
   * Renders a HTML content tag.
   *
   * @param string $tag         The tag name
   * @param string $content     The content of the tag
   * @param array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
   *
   * @param string An HTML tag string
   */
  public function renderContentTag($tag, $content = null, $attributes = array())
  {
    if (empty($tag))
    {
      return '';
    }

    return sprintf('<%s%s>%s</%s>', $tag, $this->attributesToHtml($attributes), $content, $tag);
  }

}