<?php

/**
 * hotelWidgetFormChoice represents an HTML input tag, with rounded corners div's
 *
 */
class sfHotelWidgetFormBtnChoice extends sfWidgetFormSelect {

    protected function configure($options = array(), $attributes = array()) {
        parent::configure($options, $attributes);

        $this->addOption('multiple', false);

        $this->addOption('image', 'empty-icon');
        $this->addOption('expanded', false);
        $this->addOption('renderer_class', false);
        $this->addOption('renderer_options', array());
        $this->addOption('renderer', false);
    }

    public function formatter($widget, $inputs) {
        $rows = array();

        foreach ($inputs as $key => $input) {

            if (strpos($input['input'], 'checked="checked"')) {
                $class = "active";
            } else {
                $class = "";
            }

            if (strpos($input['input'], 'disabled="disabled"')) {
                $disabled = TRUE;
            } else {
                $disabled = FALSE;
            }

            preg_match('/id="(.*?)\"/', $input['input'], $matches, PREG_OFFSET_CAPTURE);

            foreach ($matches as $match) {
                $id = $match;
            }

            if ($disabled) {
                $inline = array('class' => 'element-group-inline ' . $class);
            } else {
                $inline = array('class' => 'element-group-inline ' . $class
                    , 'onclick' => " 
                  $(this).parent().find('.element-group-inline').removeClass('active'); 
                  $(this).addClass('active');
        ");
            }


            if (strpos($input['input'], 'disabled="disabled"')) {
                $class .= " disabled ";
                $inline = array('class' => 'element-group-inline ' . $class);
            }

            $rows[] = $this->renderContentTag('div', sprintf("%s%s"
                            , $this->renderContentTag('div', $input['input'], array('class' => 'controls w0h0'))
                            , $this->renderContentTag('i', $input['label'], array('class' => 'icon-' . $key)))
                    , $inline);
        }


        return !$rows ? '' : implode('', $rows);
    }

    public function render($name, $value = null, $attributes = array(), $errors = array()) {
        if ($this->getOption('multiple')) {
            $attributes['multiple'] = 'multiple';

            if ('[]' != substr($name, -2)) {
                $name .= '[]';
            }
        }

        if (!$this->getOption('renderer') && !$this->getOption('renderer_class') && $this->getOption('expanded')) {
            unset($attributes['multiple']);
        }

        return $this->getRenderer()->render($name, $value, $attributes, $errors);
    }

    public function getRenderer() {
        if ($this->getOption('renderer')) {
            return $this->getOption('renderer');
        }

        if (!$class = $this->getOption('renderer_class')) {
            $type = !$this->getOption('expanded') ? '' : ($this->getOption('multiple') ? 'checkbox' : 'radio');
            $class = sprintf('sfWidgetFormSelect%s', ucfirst($type));
        }

        $options = $this->options['renderer_options'];
        $options['choices'] = new sfCallable(array($this, 'getChoices'));

        $renderer = new $class($options, $this->getAttributes());

        // choices returned by the callback will already be translated (so we need to avoid double-translation)
        if ($renderer->hasOption('translate_choices')) {
            $renderer->setOption('translate_choices', false);
        }

        $renderer->setParent($this->getParent());

        return $renderer;
    }

    public function getChoices() {
        $choices = $this->getOption('choices');

        if ($choices instanceof sfCallable) {
            $choices = $choices->call();
        }

        if (!$this->getOption('translate_choices')) {
            return $choices;
        }

        $results = array();


        $i = 0;
        foreach ($choices as $key => $choice) {
            if (is_array($choice)) {
                $results[$this->translate($key)] = $choice;
            } else {
                $results[$key] = $choice;
            }

            $i++;
        }

        return $results;
    }

    /**
     * @param string $value
     * @return sfArtWidgetFormChoice|sfWidget
     */
    public function setLabel($value) {

        if ($this->getOption('required'))
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';

        $this->setOption('label', $value);

        return $this;
    }

}
