<?php

/**
 * hotelWidgetFormChoice represents an HTML input tag, with rounded corners div's
 *
 */
class sfHotelWidgetFormImageChoice extends sfWidgetFormSelect {

  protected function configure($options = array(), $attributes = array()) {
    parent::configure($options, $attributes);

    $this->addOption('multiple', false);

    $this->addOption('image', 'empty-icon');
    $this->addOption('expanded', false);
    $this->addOption('renderer_class', false);
    $this->addOption('renderer_options', array());
    $this->addOption('renderer', false);
  }

  public function formatter($widget, $inputs) {
    $rows = array();
    
//    var_dump($widget); 
//    var_dump($inputs); 
//    
    foreach ($inputs as $key => $input) {
//    var_dump($input); 
//    var_dump($key); 

      if (strpos($input['input'], 'checked="checked"')) {
        $class = "active";
      } else {
        $class = "";
      }
      
      if (strpos($input['input'], 'disabled="disabled"')) {
        $disabled = TRUE;
      } else {
        $disabled = FALSE;
      }
      
      if ($disabled){
        $class .= ' inactive-grayscale'; 
      }

      preg_match('/id="(.*?)\"/', $input['input'], $matches, PREG_OFFSET_CAPTURE);

      foreach ($matches as $match) {
        $id = $match;
      }

      preg_match('/name="(.*?)\"/', $input['input'], $matches, PREG_OFFSET_CAPTURE);

      foreach ($matches as $match) {
        $name = $match;
      }
      
//      $articleObject = Doctrine::getTable('Article')->getArticleByUniqueNameWithPhotos('przykladowe-loga'); 
//      $article = Doctrine::getTable('Article')->getArticleByUniqueNameWithPhotos('przykladowe-loga'); 
//
//      
//      $actionBar =  new FmActionBar($article);
//      
//     $article = Doctrine::getTable('Article')->getArticleByUniqueNameWithPhotos('przykladowe-loga'); 
//    
//    $actionBar =  new FmActionBar($article);
    
      $src = substr(strip_tags($input['label']),0,110);
      
      $rows[] =
              $this->renderContentTag('div',
                      $this->renderContentTag('div', sprintf("%s%s"
                              , $this->renderContentTag('div', $input['input'], array('class' => 'controls'))
//                              , $this->renderContentTag('a', $this->renderContentTag('i', "?", array('class' => 'hotel-icon-empty'))
//                                      , array('class' => 'fl widget-icon wi-' . $key, 'tooltip' => 'true', 'data-toggle' => 'tooltip', 'data-original-title' => __tt("help_$key")))
                              , '<img src=\''.$src.'\' alt=\'\' />'))
//                              $this->renderContentTag('label', $input['label'], array('class' => 'element-label'))), array('class' => 'hover-container'))
              , array('class' => "element-group images  $class bg_$key",
          'onclick' => $this->setOnClick($name[0], $id[0], $disabled)));
    }


    
    return (!$rows ? '' : implode('', $rows));
  }
  
  public function setOnClick($name, $id, $disabled){
    
    if ($disabled){
      return 'return false;';
    } else {
      return "Helper.widgetClick('$name','$id', $(this));"; 
    }
  }

  public function render($name, $value = null, $attributes = array(), $errors = array()) {
    if ($this->getOption('multiple')) {
      $attributes['multiple'] = 'multiple';

      if ('[]' != substr($name, -2)) {
        $name .= '[]';
      }
    }

    if (!$this->getOption('renderer') && !$this->getOption('renderer_class') && $this->getOption('expanded')) {
      unset($attributes['multiple']);
    }

    return $this->getRenderer()->render($name, $value, $attributes, $errors);
  }

  public function getRenderer() {
    if ($this->getOption('renderer')) {
      return $this->getOption('renderer');
    }

    if (!$class = $this->getOption('renderer_class')) {
      $type = !$this->getOption('expanded') ? '' : ($this->getOption('multiple') ? 'checkbox' : 'radio');
      $class = sprintf('sfWidgetFormSelect%s', ucfirst($type));
    }

    $options = $this->options['renderer_options'];
    $options['choices'] = new sfCallable(array($this, 'getChoices'));

    $renderer = new $class($options, $this->getAttributes());

    // choices returned by the callback will already be translated (so we need to avoid double-translation)
    if ($renderer->hasOption('translate_choices')) {
      $renderer->setOption('translate_choices', false);
    }

    $renderer->setParent($this->getParent());

    return $renderer;
  }

  public function getChoices() {
    $choices = $this->getOption('choices');

    if ($choices instanceof sfCallable) {
      $choices = $choices->call();
    }

    if (!$this->getOption('translate_choices')) {
      return $choices;
    }

    $results = array();


    $i = 0;

    foreach ($choices as $key => $choice) {

      if (is_array($choice)) {
        $results[$this->translate($key)] = $choice['src'];
      } else {
        $results[$key] = $choice['src'];
      }

      $i++;
    }

    return $results;
  }

  /**
   * @param string $value
   * @return sfArtWidgetFormChoice|sfWidget
   */
  public function setLabel($value) {

    if ($this->getOption('required'))
      $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';

    $this->setOption('label', $value);

    return $this;
  }

}
