<?php

/**
 */
class sfHotelWidgetFormImageInput extends sfWidgetFormInputFileEditable {

  /**
   * @param array $options
   * @param array $attributes
   */
  public function configure($options = array(), $attributes = array()) {
    parent::configure($options, $attributes);
    sfContext::getInstance()->getConfiguration()->loadHelpers(array('I18N', 'ArteneoPartial'));
    $this->setOption('template', '
    <div class="fileupload fileupload-new" data-provides="fileupload">
      <div class="fileupload-preview thumbnail mb10" style="max-width: 100px; max-height: 100px; line-height: 100px;">%file%</div>
      <span class="btn btn-file">
        <span class="fileupload-new">Wybierz plik</span>
        <span class="fileupload-exists"></span>
        %input%
      </span>
    </div>');
  }

  public function setLabel($value) {
    if ($this->getOption('required'))
      $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
    $this->setOption('label', $value);

    return $this;
  }

  protected function getFileAsTag($attributes) {
    artEscaper::setDefaultInArray($attributes, 'alt', ' ');

    if ($this->getOption('is_image'))
      return false !== $this->getOption('file_src') ? $this->renderTag('img', array_merge(array('class' => 'image-class-logo-firm', 'src' => $this->getOption('file_src')), $attributes)) : '';
    else
      return $this->getOption('file_src');
  }

  /**
   * @param string $name
   * @param null $value
   * @param array $attributes
   * @param array $errors
   * @return string
   */
  public function render($name, $value = null, $attributes = array(), $errors = array()) {
    return parent::render($name, $value, $attributes, $errors) . get_partial_if_not_get('partials/ajax_file_upload_assets');
  }

}
