<?php

/**
 * sfArtWidgetFormInput represents an HTML input tag, with rounded corners div's
 *
 */
class sfHotelWidgetFormInput extends sfWidgetFormInput {

    /**
     * @param  string $name        The element name
     * @param  string $value       The value displayed in this widget
     * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
     * @param  array  $errors      An array of errors for the field
     *
     * @return string An HTML tag string
     *
     * @see sfWidgetFormInput
     */
    public function render($name, $value = null, $attributes = array(), $errors = array()) {
        $c = "";

        if (isset($attributes['class'])) {
            $c = $attributes['class'];
        }

        $id = str_replace(array('['), '_', $name);
        $id = str_replace(array(']'), '', $id);

        if (isset($attributes['disabled']) && $attributes['disabled'] === 'disabled') {
            $disabled = TRUE;
        } else {
            $disabled = FALSE;
        }

        $s = '<div class="hotel input">'
                . artBox::beginBox('horizontal')
                . $this->renderContentTag('div', '- 5', array('class' => 'minus btn'
                    , 'onclick' => $this->setOnClick($id, -5, $disabled)))
                . parent::render($name, $value, array_merge($attributes, array()), $errors)
                . $this->renderContentTag('div', '+ 5', array('class' => 'plus btn'
                    , 'onclick' => $this->setOnClick($id, 5, $disabled)))
                . artBox::endBox('horizontal')
                . '</div>';

        return $s;
    }

    public function setOnClick($id, $value, $disabled) {

        if ($disabled) {
            return 'return false;';
        } else {
            return '$(\'#' . $id . '\').removeAttr(\'disabled\'); 
                $(\'#' . $id . '\').attr(\'value\', parseInt( $(\'#' . $id . '\').attr(\'value\')) + ' . $value . '); $(\'#' . $id . '\').change(); 
                $(\'#' . $id . '\').attr(\'disabled\', \'disabled\'); 
                return false;';
        }
    }

    /**
     * @param string $value
     * @return sfArtWidgetFormInput|sfWidget
     */
    public function setLabel($value) {
        if ($this->getOption('required')) {
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
        }

        $this->setOption('label', $value);

        return $this;
    }

}
