<?php

class sfHotelWidgetFormSlider extends sfWidgetFormInput {

  /**
   * @param  string $name        The element name
   * @param  string $value       The value displayed in this widget
   * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
   * @param  array  $errors      An array of errors for the field
   *
   * @return string An HTML tag string
   *
   * @see sfWidgetFormInput
   */
  public function render($name, $value = null, $attributes = array(), $errors = array()) {
    $c = "";
    if (isset($attributes['class']))
      $c = $attributes['class'];

    $id = str_replace(array('['), '_', $name);
    $id = str_replace(array(']'), '', $id);

    $s = '<div class="hotel input slider">'
            . artBox::beginBox('horizontal')
            . parent::render($name, $value, array_merge($attributes, array()), $errors)
            . artBox::endBox('horizontal')
            . '<span sliderId="'.$id.'"></span>'
        . '</div>';
    
    $js = '<script type="text/javascript">/* <![CDATA[ */' . "\n";
    $js .= '$(function() {' . "\n";
    $js .= '   $(\'[sliderId="'.$id.'"]\').slider({' . "\n";
    
    if (isset($attributes['range']))
      $js .= '       range: "'.$attributes['range'].'",' . "\n";
    else 
      $js .= '       range: "max",' . "\n";
    
    if (isset($attributes['min']))
      $js .= '       min: '.$attributes['min'].',' . "\n";
    else 
      $js .= '       min: 1,' . "\n";
    
    if (isset($attributes['max']))
      $js .= '       max: '.$attributes['max'].',' . "\n";
    else
      $js .= '       max: 10,' . "\n";
    
    if (!is_null($value))
      $js .= '       value: '.$value.' ,' . "\n";
    else 
      $js .= '       value: 0 ,' . "\n";
    
    $js .= '       change: function( event, ui ) {' . "\n";
    $js .= '          $( "#'.$id.'" ).val( ui.value );' . "\n";
    $js .= '          $( "#'.$id.'" ).change();' . "\n";
    $js .= '       }' . "\n";
    $js .= '   });' . "\n";
    $js .= '$( "#'.$id.'" ).val( $(\'[sliderId="'.$id.'"]\').slider( "value" ));' . "\n";
    $js .= '$("#'.$id.'").blur(function() {
                $(\'[sliderId="'.$id.'"]\').slider(\'option\', \'value\', parseInt($(this).val()));
            });';
    $js .= '});' . "\n";
    $js .= '/* ]]> */</script>' . "\n"; 
    
    return $s.$js;
  }

  /**
   * @param string $value
   * @return sfArtWidgetFormInput|sfWidget
   */
  public function setLabel($value) {
    if ($this->getOption('required'))
      $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
    $this->setOption('label', $value);

    return $this;
  }

}
