DROP FUNCTION IF EXISTS article_flash_get_position;
DELIMITER //
CREATE FUNCTION article_flash_get_position(_unique_name VARCHAR(100), _slug VARCHAR(255), _lang CHAR(2) )
  RETURNS INT
  DETERMINISTIC
  BEGIN
    DECLARE _rank INT;
   
    SET @rownum := 0; # create the variable
    set _rank = 0;
    select b.rank 
        from ( select @rownum := @rownum+1 AS rank, a.id, a.slug, a.name, a.title 
            from ( SELECT  `a`.`id` AS id, a4.slug as slug, `a2`.`unique_name` AS name,  `a4`.`title` AS title 
                FROM `article` `a` 
                LEFT JOIN `article_article_category` `a3` ON (`a`.`id` = `a3`.`article_id`) 
                LEFT JOIN `article_category` `a2` ON `a2`.`id` = `a3`.`category_id` 
                LEFT JOIN `article_translation` `a4` ON `a`.`id` = `a4`.`id` 
                AND (`a4`.`lang` = _lang) 
                WHERE  (`a2`.`unique_name` = _unique_name AND `a`.`is_displayed` = '1') 
                ORDER BY `a3`.`order` ASC ) a
        ) b 
    where b.slug = _slug LIMIT 1 INTO _rank;
     
    RETURN _rank;
  END //
DELIMITER ;