DROP PROCEDURE IF EXISTS set_article_order;
DELIMITER //
CREATE PROCEDURE set_article_order
(
      IN category_id VARCHAR(1000), 
      IN article_id INT(11) 
)
BEGIN
   DECLARE _query VARCHAR(2300);  

   START TRANSACTION;

   DROP TABLE IF EXISTS article_temporary_order;

   SET @_query = CONCAT('CREATE TABLE article_temporary_order AS SELECT max(b.order)+1 AS o, b.category_id AS c FROM article_article_category b WHERE b.category_id IN (', category_id ,');');
   
   PREPARE stmt FROM @_query; 
   EXECUTE stmt;
   DEALLOCATE PREPARE stmt;

   SET _query = CONCAT('UPDATE article_article_category a JOIN article_temporary_order ON article_temporary_order.c=a.category_id SET a.order = article_temporary_order.o WHERE a.category_id IN (', category_id ,') AND a.article_id=',article_id);

   SET @_query = _query;

   PREPARE stmt FROM @_query; 
   EXECUTE stmt;
   DEALLOCATE PREPARE stmt;

   COMMIT;
END //
DELIMITER ;