<?php

class artCmsPluginActions extends artActions {

 
  /*
   * Akcja wyświetlająca artykuł.
   *
   * @params sfWebRequest $request;
   * - slug , slug artykułu.
   */

  public function executeShow(sfWebRequest $request) {
    $this->article = $this->getRequest()->getParameter('object', NULL);

    if (empty($this->article)) {
      $this->forward404("Brak obiektu artykułu");
    }

    if (sfConfig::get('app_art_cms_plugin_article_slot', FALSE))
      $this->getResponse()->setSlot("article", $this->article);

    $this->checkArticlePermissions($this->article);

    ArtConfiguration::setArticleMetaTags($this->article, $this->getResponse());
    return $this->layout($this->article);
  }

  /**
   * Lista artykułów
   * 
   * @param sfWebRequest $request
   */
  public function executeList(sfWebRequest $request) {
    $this->params = array();
    $this->params['page'] = $page = 1;
    $this->params['categoryObject'] = $this->categoryObject = $this->getRequest()->getParameter('object', NULL);

    if (empty($this->categoryObject)) {
      $this->forward404("Brak obiektu kategorii");
    }

    foreach ($this->getListParams($this->categoryObject, $request) as $key => $value) {
      $$key = $value;
      $this->params[$key] = $value;
    }

    $this->params['count'] = Doctrine_Core::getTable('Article')->getArticleOfCategoryCountById($this->categoryObject->getId(), $createdAtLessThanNow, $createdAt);
    $this->params['unique_name'] = $this->categoryObject->getUniqueName();
    $this->params['slug'] = $this->categoryObject->getSlug();
    $this->params['offset'] = ($page - 1) * $limit;
    $this->params['page_count'] = ceil($this->params['count'] / $limit);

    return $this->layout($this->categoryObject);
  }

  /**
   * 
   */
  public function getListParams(Category $object, sfWebRequest $request) {

    if (!empty($object)) {

      return array(
          'limit' => $object->getParam('limit', 5),
          'createdAtLessThanNow' => $object->getParam('createdAtLessThanNow', FALSE),
          'orderAsc' => $object->getParam('orderAsc', TRUE),
          'orderCreatedAtDesc' => $object->getParam('orderCreatedAtDesc', FALSE),
          'createdAt' => $object->getParam('createdAt', NULL),
              ) + $request->getParameterHolder()->getAll();
    }

    return array(
        'limit' => 5,
        'createdAtLessThanNow' => FALSE,
        'orderAsc' => TRUE,
        'orderCreatedAtDesc' => FALSE,
        'createdAt' => NULL,
            ) + $request->getParameterHolder()->getAll();
  }

  /**
   * 
   * @param Article/Category $object
   * @return type
   */
  public function layout($object) {

    $view = $object->getLayout()->getView();

    if ($view == 'NotApplicable') {

      if ($this->getRequest()->isXmlHttpRequest()) {

        $this->getResponse()->setContentType('application/json');
        $object = $object->exportTo('json');

        return $this->renderText($object);
      } else {
        $this->forward404('Object is NotApplicable');
      }
    } else {
      $this->setLayout("layout_$view");
    }

    return $view;
  }

  /**
   * 
   * @param type $article
   * @return string
   */
  public function checkArticlePermissions(Article $article) {
    $this->permissions = false;

    if ($this->getUser()->hasPermission('article_edit')) {
      $this->permissions = true;
    }

    if ($article)
      $articlePermissions = $article->getPermissionsNames();

    if (!empty($articlePermissions)) {
      if ($this->getUser()->isAuthenticated())
        $userPermissions = $this->getUser()->getGuardUser()->getPermissionNames();
      else
        $this->forward404('NoPermissions');

      $neededPermissions = array_intersect($userPermissions, $articlePermissions);

      if (empty($neededPermissions))
        $this->forward404('NoPermissions');
    }
  }

  public function getObject(sfWebRequest $request) {
    $object = $this->tryGetArticleObject($request);

    if (empty($object)) {
      $object = $this->tryGetCategoryObject($request);
    }

    return $object;
  }

  public function tryGetArticleObject(sfWebRequest $request) {
    $slug = $request->getParameter('slug', FALSE);
    $article = null;

    if ($slug) {

      $article = Doctrine::getTable('Article')->getArticleBySlug($slug);

      if (empty($article)) {
        $slug = Doctrine::getTable('Article')->getOtherCultureSlugBySlug($slug);

        if ($slug)
          $article = Doctrine::getTable('Article')->getArticleBySlug($slug);

        // to do, nie działa do końca
        if (!empty($article)) {
          $lang = $article->getLang();
          if (in_array($lang, sfConfig::get('sf_cultures', array('pl'))))
            $this->getUser()->setCulture($lang);
          else
            $this->getUser()->setCulture('pl');
        }
      }

      if (!empty($article) && $article->hasViews()) {
        $article->setViews($article->getViews() + 1);
        $article->save();
      }
    } else {
      $unique_name = $request->getParameter('unique_name', FALSE);


      if ($unique_name) {
        $article = Doctrine::getTable('Article')->getArticleByUniqueName($unique_name);
      }
    }

    return $article;
  }

  public function tryGetCategoryObject(sfWebRequest $request) {
    $slug = $request->getParameter('slug');
    $category = Doctrine::getTable('Category')->getBySlug($slug);

    if (empty($category)) {
      $slug = Doctrine::getTable('Category')->getOtherCultureSlugBySlug($slug);

      if ($slug)
        $category = Doctrine::getTable('Category')->getBySlug($slug);

      // to do, nie działa do końca
      if (!empty($category)) {
        $lang = $category->getLang();
        if (in_array($lang, sfConfig::get('sf_cultures', array('pl'))))
          $this->getUser()->setCulture($lang);
        else
          $this->getUser()->setCulture('pl');
      }
    }

    return $category;
  }

//  /**
//   * 
//   * @param sfWebRequest $request
//   * @return type
//   */
//  public function getArticle(sfWebRequest $request, $redirect = true) {
//    $slug = $request->getParameter('slug');
//    $uniqueName = $request->getParameter('unique_name', false);
//    $actionModule = $this->getModuleName();
//
////    if ($uniqueName) {
////      $article = Doctrine::getTable('Article')->getArticleDataByUniqueName($uniqueName);
////
////      if (empty($article) || !$article->isDisplayedAndActive()) {
////        $this->forward404('Podany artykuł nie istnieje lub jest nieaktywny!');
////      }
////
////      $module = $article->getLayout()->getModule()->getName();
////      if (!in_array($module, sfConfig::get('sf_enabled_modules'))) {
////        throw new sfException(sprintf("Moduł '%s' nie istnieje lub nie został włączony", $module));
////      }
////
////      if ($actionModule != $module && $redirect) {
////        $this->redirect('@' . $module . '_show_unique_name?unique_name=' . $uniqueName);
////      }
////    } else {
//    $article = Doctrine::getTable('Article')->getArticleBySlug($slug);
//
//    if (empty($article) || !$article->isDisplayedAndActive()) {
//      $slug = Doctrine::getTable('Article')->getOtherCultureSlugBySlug($slug);
//
//      if ($slug && $redirect)
//        $this->redirect('@' . $actionModule . '_show?slug=' . $slug);
//
//      $this->forward404('Podany artykuł nie istnieje lub jest nieaktywny!');
//      $this->redirect('@homepage');
//    }
//
//    $module = $article->getLayout()->getModule()->getName();
//
//    if (!in_array($module, sfConfig::get('sf_enabled_modules'))) {
//      throw new sfException(sprintf("Moduł '%s' nie istnieje lub nie został włączony", $module));
//    }
//
//    if ($actionModule != $module && $redirect) {
//      $this->redirect('@' . $module . '_show?slug=' . $slug);
//    }
////    }
//
//    return $article;
//  }
//  public function getCategory(sfWebRequest $request, $redirect = true) {
//
//    $slug = $request->getParameter('slug', false);
//    $uniqueName = $request->getParameter('unique_name', false);
//    $actionModule = $this->getModuleName();
//
////    if ($uniqueName && !$slug) {
////      $category = Doctrine::getTable('Category')->getByUniqueName($uniqueName);
////
////      if (empty($category)){
////        $this->forward404(sprintf('Podana kategoria "%s" nie istnieje!', $uniqueName));
////      }
////
////      $module = str_replace("_category", "", $category->getLayout()->getModule()->getName());
////
////      if (!in_array($module, sfConfig::get('sf_enabled_modules'))) {
////        throw new sfException(sprintf("Moduł '%s' nie istnieje lub nie został włączony", $module));
////      }
////
////      if ($actionModule != $module && $redirect) {
////        $this->redirect('@' . $module . '_list_unique_name?unique_name=' . $uniqueName);
////      }
////    } else {
//    $category = Doctrine::getTable('Category')->getBySlug($slug);
//
//
//    if (empty($category)) {
//      $slug = Doctrine::getTable('Category')->getOtherCultureSlugBySlug($slug);
//
//      if ($slug && $redirect)
//        $this->redirect('@' . $actionModule . '_list?slug=' . $slug);
//
//      $this->forward404(sprintf('Podana kategoria "%s" nie istnieje!', $slug));
//      $this->redirect('@homepage');
//    }
//
//    $module = str_replace("_category", "", $category->getLayout()->getModule()->getName());
//
//    if (!in_array($module, sfConfig::get('sf_enabled_modules'))) {
//      throw new sfException(sprintf("Moduł '%s' nie istnieje lub nie został włączony", $module));
//    }
//
//    if ($actionModule != $module && $redirect) {
//      $this->redirect('@' . $module . '_list?slug=' . $slug);
//    }
////    }
//
//    if (sfConfig::get('app_art_cms_plugin_category_slot', FALSE))
//      $this->getResponse()->setSlot("category", $category);
//
//    return $category;
//  }
}
